/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.mesas_restaurante;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.ClienteRequest;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.ClienteResponse;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.MenuResponse;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.MesaResponse;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.PlatoResponse;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.ReservaRequest;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.ReservaResponse;
import org.springframework.ai.mcp.sample.server.tools.mesas_restaurante.RestauranteTool;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class RestauranteToolServiceImpl
implements RestauranteTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestauranteToolServiceImpl.class);
    private final WebClient.Builder webClientBuilder;
    private final Environment env;
    private final ObjectMapper objectMapper;

    private String getApiBaseUrl() {
        String baseUrl = this.env.getProperty("api-restaurante");
        log.info("\ud83c\udf10 API BASE URL: {}", (Object)baseUrl);
        return baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
    }

    private WebClient webClient() {
        return this.webClientBuilder.build();
    }

    @Tool(description="Crea un nuevo cliente en el sistema del restaurante")
    public ClienteResponse restaurante_crearCliente(ClienteRequest cliente) {
        String url = this.getApiBaseUrl() + "/clientes";
        log.info("\ud83d\udce4 POST \u2192 {}", (Object)url);
        if (cliente == null) {
            log.error("\u26a0\ufe0f Cliente recibido es null. Revisa que MCP env\u00ede un JSON correcto");
            throw new IllegalArgumentException("Cliente no puede ser null");
        }
        log.info("\ud83d\udce4 Body recibido: {}", (Object)cliente);
        try {
            ClienteResponse response = (ClienteResponse)((WebClient.RequestBodySpec)this.webClient().post().uri(url, new Object[0])).bodyValue((Object)cliente).retrieve().bodyToMono(ClienteResponse.class).block();
            log.info("\u2705 Cliente creado correctamente: {}", (Object)response);
            return response;
        }
        catch (WebClientResponseException e) {
            log.error("\ud83d\udca5 Error HTTP {} al crear cliente: {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            throw new RuntimeException("Error HTTP: " + String.valueOf(e.getStatusCode()));
        }
        catch (Exception e) {
            log.error("\ud83d\udd25 Error al crear cliente: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("No se pudo crear el cliente. Verifica la API.");
        }
    }

    @Tool(description="Crea una nueva reserva para un cliente en el restaurante, antes de crear asegurate de usar restaurante_buscarCliente y con el 'id' del cliente usarlo como id_cliente")
    public ReservaResponse restaurante_crearReserva(ReservaRequest reserva) {
        String url = this.getApiBaseUrl() + "/reservas";
        try {
            String jsonBody = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)reserva);
            log.info("\ud83d\udce4 POST \u2192 {}\n\ud83d\udce6 Body enviado:\n{}", (Object)url, (Object)jsonBody);
            ReservaResponse response = (ReservaResponse)((WebClient.RequestBodySpec)this.webClient().post().uri(url, new Object[0])).bodyValue((Object)reserva).retrieve().bodyToMono(ReservaResponse.class).block();
            log.info("\u2705 Reserva creada correctamente: {}", (Object)response);
            return response;
        }
        catch (WebClientResponseException e) {
            log.error("\ud83d\udca5 Error HTTP {} al crear reserva: {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            throw new RuntimeException("Error HTTP: " + String.valueOf(e.getStatusCode()));
        }
        catch (Exception e) {
            log.error("\ud83d\udd25 Error al crear reserva: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("No se pudo crear la reserva. Verifica la API.");
        }
    }

    @Tool(description="Cancela una reserva existente por su ID")
    public String restaurante_cancelarReserva(int reservaId) {
        String url = this.getApiBaseUrl() + "/reservas/cancelar/" + reservaId;
        log.info("PATCH \u2192 {}", (Object)url);
        try {
            return (String)((WebClient.RequestBodySpec)this.webClient().patch().uri(url, new Object[0])).retrieve().bodyToMono(String.class).block();
        }
        catch (Exception e) {
            log.error("\u274c Error al cancelar reserva: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al cancelar reserva: " + e.getMessage());
        }
    }

    @Tool(description="Lista todas las reservas o las del cliente especificado, antes de listar asegurate de usar restaurante_buscarCliente y con el 'id' del cliente usarlo como clienteId\"")
    public List<ReservaResponse> restaurante_listarReservas(Integer clienteId) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getApiBaseUrl() + "/reservas/cliente"));
        if (clienteId != null) {
            uriBuilder.queryParam("cliente_id", new Object[]{clienteId});
        }
        String url = uriBuilder.toUriString();
        log.info("\ud83d\udd0d GET \u2192 {}", (Object)url);
        try {
            ReservaResponse[] response = (ReservaResponse[])this.webClient().get().uri(url, new Object[0]).retrieve().bodyToMono(ReservaResponse[].class).block();
            return Arrays.asList(response != null ? response : new ReservaResponse[]{});
        }
        catch (Exception e) {
            log.error("\u274c Error al listar reservas: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al listar reservas: " + e.getMessage());
        }
    }

    @Tool(description="Lista los men\u00fas vigentes del restaurante. Siempre env\u00eda una fecha. Si no se especifica, usa la fecha y hora actuales.")
    public List<MenuResponse> restaurante_listarMenusVigentes(LocalDateTime targetDateTime) {
        try {
            LocalDateTime effectiveDateTime = targetDateTime != null ? targetDateTime : LocalDateTime.now();
            String formattedDate = effectiveDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            log.info("\ud83d\udcc5 Fecha usada para listar men\u00fas \u2192 {}", (Object)formattedDate);
            String url = UriComponentsBuilder.fromHttpUrl((String)(this.getApiBaseUrl() + "/menus/fecha")).queryParam("target_datetime", new Object[]{formattedDate}).toUriString();
            log.info("\ud83c\udf10 GET \u2192 {}", (Object)url);
            MenuResponse[] response = (MenuResponse[])this.webClient().get().uri(url, new Object[0]).retrieve().bodyToMono(MenuResponse[].class).block();
            if (response != null) {
                try {
                    ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                    String jsonResponse = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                    log.info("\u2705 Respuesta de men\u00fas:\n{}", (Object)jsonResponse);
                }
                catch (Exception jsonEx) {
                    log.warn("\u26a0\ufe0f No se pudo formatear la respuesta en JSON: {}", (Object)jsonEx.getMessage());
                }
            } else {
                log.warn("\u26a0\ufe0f No se recibieron men\u00fas desde la API.");
            }
            return Arrays.asList(response != null ? response : new MenuResponse[]{});
        }
        catch (Exception e) {
            log.error("\u274c Error al listar men\u00fas: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al listar men\u00fas: " + e.getMessage());
        }
    }

    @Tool(description="Lista todos los platos disponibles")
    public List<PlatoResponse> restaurante_listarPlatos() {
        String url = this.getApiBaseUrl() + "/platos";
        log.info("GET \u2192 {}", (Object)url);
        try {
            PlatoResponse[] response = (PlatoResponse[])this.webClient().get().uri(url, new Object[0]).retrieve().bodyToMono(PlatoResponse[].class).block();
            return Arrays.asList(response != null ? response : new PlatoResponse[]{});
        }
        catch (Exception e) {
            log.error("\u274c Error al listar platos: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al listar platos: " + e.getMessage());
        }
    }

    @Tool(description="Busca un cliente por su n\u00famero de WhatsApp")
    public ClienteResponse restaurante_buscarCliente(String whatsapp) {
        String url = this.getApiBaseUrl() + "/clientes/whatsapp/" + whatsapp;
        log.info("\ud83d\udd0d GET \u2192 {}", (Object)url);
        try {
            ClienteResponse response = (ClienteResponse)this.webClient().get().uri(url, new Object[0]).retrieve().bodyToMono(ClienteResponse.class).doOnSubscribe(sub -> log.info("\ud83d\udce1 Enviando solicitud...")).doOnSuccess(r -> log.info("\u2705 Respuesta recibida: {}", r)).doOnError(err -> log.error("\ud83d\udca5 Error al recibir respuesta: {}", (Object)err.getMessage())).block();
            if (response == null) {
                log.warn("\u26a0\ufe0f No se encontr\u00f3 cliente o la respuesta fue vac\u00eda.");
            }
            return response;
        }
        catch (WebClientResponseException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                log.warn("\u26a0\ufe0f Cliente no encontrado (404)");
                return null;
            }
            log.error("\ud83d\udca5 Error HTTP al buscar cliente: {}", (Object)e.getResponseBodyAsString());
            throw new RuntimeException("Error HTTP al buscar cliente: " + String.valueOf(e.getStatusCode()));
        }
        catch (Exception e) {
            log.error("\ud83d\udd25 Error general al buscar cliente: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Error general al buscar cliente: " + e.getMessage());
        }
    }

    @Tool(description="Obtiene la lista de mesas disponibles para reservar en una fecha espec\u00edfica. Si no se indica una, se usa la actual.")
    public List<MesaResponse> restaurante_listarMesasDisponibles(LocalDateTime fecha_reserva) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            String formattedDate = fecha_reserva != null ? fecha_reserva.format(formatter) : LocalDateTime.now().format(formatter);
            String url = UriComponentsBuilder.fromHttpUrl((String)(this.getApiBaseUrl() + "/mesas/disponibles")).queryParam("fecha_hora", new Object[]{formattedDate}).toUriString();
            log.info("\ud83e\ude91 GET \u2192 {}", (Object)url);
            MesaResponse[] response = (MesaResponse[])this.webClient().get().uri(url, new Object[0]).retrieve().bodyToMono(MesaResponse[].class).block();
            return Arrays.asList(response != null ? response : new MesaResponse[]{});
        }
        catch (Exception e) {
            log.error("\ud83d\udca5 Error al listar mesas disponibles: {}", (Object)e.getMessage());
            throw new RuntimeException("Error al listar mesas disponibles: " + e.getMessage());
        }
    }

    @Generated
    public RestauranteToolServiceImpl(WebClient.Builder webClientBuilder, Environment env, ObjectMapper objectMapper) {
        this.webClientBuilder = webClientBuilder;
        this.env = env;
        this.objectMapper = objectMapper;
    }
}

