/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.canchas_padel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.Cancha;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.PadelTool;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.PeticionCancelacionReserva;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.PeticionDisponibilidad;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.PeticionDisponibilidadDiaria;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.PeticionReserva;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.PeticionVerReservas;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.RespuestaCancelacionReserva;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.RespuestaDisponibilidad;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.RespuestaDisponibilidadDiaria;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.RespuestaReserva;
import org.springframework.ai.mcp.sample.server.tools.canchas_padel.RespuestaVerReservas;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@Service
public class PadelToolServiceImpl
implements PadelTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PadelToolServiceImpl.class);
    private final WebClient.Builder webClientBuilder;
    private final Environment env;
    private final ObjectMapper objectMapper;

    private String getFastApiBaseUrl() {
        return this.env.getProperty("api-padel");
    }

    @Tool(description="Busca bloques de tiempo disponibles en todos los clubes para una fecha espec\u00edfica (YYYY-MM-DD). \u00dasese al iniciar la b\u00fasqueda de canchas.")
    public RespuestaDisponibilidadDiaria padel_encontrarBloquesDisponibles(PeticionDisponibilidadDiaria peticion) {
        String url = this.getFastApiBaseUrl() + "/clubs/availability/" + peticion.fecha();
        log.info("\ud83d\udce1 Buscando disponibilidad diaria en: {}", (Object)url);
        try {
            List disponibilidad = (List)this.webClientBuilder.build().get().uri(url, new Object[0]).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).timeout(Duration.ofSeconds(10L)).block();
            if (disponibilidad == null) {
                log.warn("\u26a0\ufe0f No se recibi\u00f3 respuesta del servidor FastAPI al buscar disponibilidad.");
                return new RespuestaDisponibilidadDiaria(List.of());
            }
            String resumen = disponibilidad.stream().map(d -> String.format("%s (%d slots)", d.nombre(), d.horasDisponibles().size())).collect(Collectors.joining(", "));
            log.info("\u2705 Disponibilidad recibida para {}: {}", (Object)peticion.fecha(), (Object)resumen);
            return new RespuestaDisponibilidadDiaria(disponibilidad);
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al buscar disponibilidad: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return new RespuestaDisponibilidadDiaria(List.of());
        }
        catch (Exception e) {
            log.error("\u274c Error general al buscar disponibilidad en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error de conexi\u00f3n al buscar disponibilidad: " + e.getMessage(), e);
        }
    }

    @Tool(description="Verifica qu\u00e9 canchas espec\u00edficas est\u00e1n disponibles en un club (usando id_club), fecha y hora de inicio dados. Retorna la lista de canchas con su precio.")
    public RespuestaDisponibilidad padel_verificarDisponibilidad(PeticionDisponibilidad peticion) {
        String url = String.format("%s/clubs/%s/canchas/availability?fecha=%s&hora_inicio=%s", this.getFastApiBaseUrl(), peticion.id_club(), peticion.fecha(), peticion.hora_inicio());
        log.info("\ud83d\udce1 Verificando disponibilidad espec\u00edfica en: {}", (Object)url);
        try {
            List canchas = (List)this.webClientBuilder.build().get().uri(url, new Object[0]).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).timeout(Duration.ofSeconds(10L)).block();
            if (canchas == null || canchas.isEmpty()) {
                log.warn("\u26a0\ufe0f No se encontraron canchas disponibles en ese momento o hubo un error en FastAPI.");
                return new RespuestaDisponibilidad(List.of());
            }
            String nombresCanchas = canchas.stream().map(Cancha::nombre_cancha).collect(Collectors.joining(", "));
            log.info("\u2705 Encontradas {} canchas disponibles en {}: {}", new Object[]{canchas.size(), peticion.id_club(), nombresCanchas});
            return new RespuestaDisponibilidad(canchas);
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al verificar disponibilidad: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return new RespuestaDisponibilidad(List.of());
        }
        catch (Exception e) {
            log.error("\u274c Error general al verificar disponibilidad en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error de conexi\u00f3n al verificar disponibilidad: " + e.getMessage(), e);
        }
    }

    @Tool(description="Crea una nueva reserva en el sistema, requiere el ID del club, el ID local de la cancha, las horas de inicio y fin, y los datos del cliente.")
    public RespuestaReserva padel_crearReserva(PeticionReserva peticion) {
        String url = this.getFastApiBaseUrl() + "/reservas/";
        log.info("\ud83d\udce6 Creando reserva para cancha {} en club {}", (Object)peticion.cancha_id_local(), (Object)peticion.id_club());
        try {
            RespuestaReserva response = (RespuestaReserva)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(url, new Object[0])).bodyValue((Object)peticion).retrieve().bodyToMono(RespuestaReserva.class).timeout(Duration.ofSeconds(10L)).block();
            if (response == null || !"Confirmada".equalsIgnoreCase(response.estado())) {
                log.warn("\u26a0\ufe0f Reserva fallida o sin confirmaci\u00f3n. Estado: {}", (Object)(response != null ? response.estado() : "NULO"));
                return new RespuestaReserva("N/A", "Fallida", "La reserva no pudo ser creada o confirmada.");
            }
            log.info("\u2705 Reserva {} confirmada exitosamente.", (Object)response.id_reserva());
            return response;
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al crear reserva: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            String detail = e.getResponseBodyAsString().contains("detail") ? e.getResponseBodyAsString() : e.getMessage();
            return new RespuestaReserva("N/A", "Fallida", "Error al crear reserva: " + detail);
        }
        catch (Exception e) {
            log.error("\u274c Error general al crear reserva en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error de conexi\u00f3n al crear reserva: " + e.getMessage(), e);
        }
    }

    @Tool(description="Recupera todas las reservas activas de un cliente, usando su identificador (generalmente el n\u00famero de tel\u00e9fono).")
    public RespuestaVerReservas padel_verReservas(PeticionVerReservas peticion) {
        String url = this.getFastApiBaseUrl() + "/reservas/cliente/" + peticion.identificadorUsuario();
        log.info("\ud83d\udce2 Invocando endpoint de verReservas en: {}", (Object)url);
        log.info("\ud83d\udce1 Buscando reservas para cliente: {}", (Object)peticion.identificadorUsuario());
        try {
            List detalles = (List)this.webClientBuilder.build().get().uri(url, new Object[0]).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).timeout(Duration.ofSeconds(10L)).block();
            if (detalles == null || detalles.isEmpty()) {
                log.info("\u26a0\ufe0f No se encontraron reservas activas para el cliente.");
                return new RespuestaVerReservas(List.of());
            }
            log.info("\u2705 Encontradas {} reservas para el cliente.", (Object)detalles.size());
            return new RespuestaVerReservas(detalles);
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al ver reservas: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return new RespuestaVerReservas(List.of());
        }
        catch (Exception e) {
            log.error("\u274c Error general al ver reservas en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error de conexi\u00f3n al ver reservas: " + e.getMessage(), e);
        }
    }

    @Tool(description="Cancela una reserva existente, usando el ID de la reserva y el identificador del usuario para validaci\u00f3n.")
    public RespuestaCancelacionReserva padel_cancelarReserva(PeticionCancelacionReserva peticion) {
        String url = this.getFastApiBaseUrl() + "/reservas/" + peticion.id_reserva() + "?userIdentifier=" + peticion.identificadorUsuario();
        log.info("\ud83d\uddd1\ufe0f Intentando cancelar reserva ID: {} (Cliente: {})", (Object)peticion.id_reserva(), (Object)peticion.identificadorUsuario());
        log.info("\ud83c\udf10 Endpoint DELETE usado para cancelar: {}", (Object)url);
        try {
            RespuestaCancelacionReserva response = (RespuestaCancelacionReserva)this.webClientBuilder.build().delete().uri(url, new Object[0]).retrieve().bodyToMono(RespuestaCancelacionReserva.class).timeout(Duration.ofSeconds(10L)).block();
            if (response == null || !"Cancelada".equalsIgnoreCase(response.estado())) {
                log.warn("\u26a0\ufe0f Cancelaci\u00f3n fallida o no confirmada.");
                return new RespuestaCancelacionReserva("Fallida", response != null ? response.mensaje() : "La cancelaci\u00f3n no fue procesada.");
            }
            log.info("\u2705 Reserva {} cancelada exitosamente.", (Object)peticion.id_reserva());
            return response;
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al cancelar reserva: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            String detail = e.getResponseBodyAsString().contains("detail") ? e.getResponseBodyAsString() : e.getMessage();
            return new RespuestaCancelacionReserva("Fallida", "Error al cancelar reserva: " + detail);
        }
        catch (Exception e) {
            log.error("\u274c Error general al cancelar reserva en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error de conexi\u00f3n al cancelar reserva: " + e.getMessage(), e);
        }
    }

    @Generated
    public PadelToolServiceImpl(WebClient.Builder webClientBuilder, Environment env, ObjectMapper objectMapper) {
        this.webClientBuilder = webClientBuilder;
        this.env = env;
        this.objectMapper = objectMapper;
    }
}

