/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.autenticacion;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.mcp.sample.server.autenticacion.GenerateOtpRequest;
import org.springframework.ai.mcp.sample.server.autenticacion.OtpResponse;
import org.springframework.ai.mcp.sample.server.autenticacion.OtpToolService;
import org.springframework.ai.mcp.sample.server.autenticacion.ValidateOtpRequest;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.stereotype.Service;

@Service
public class OtpToolServiceImpl
implements OtpToolService {
    private final Map<String, String> otpStore = new HashMap();
    private final Map<String, Instant> otpExpiry = new HashMap();
    private static final long OTP_TTL_SECONDS = 180L;
    private static final String OTP_FIJO = "123456";

    @Tool(description="Una vez tengas la identificacion y primer nombre del usuario, genera el otp")
    public OtpResponse otp_generate(GenerateOtpRequest request) {
        String otp = OTP_FIJO;
        this.otpStore.put(request.identificacion(), otp);
        this.otpExpiry.put(request.identificacion(), Instant.now().plusSeconds(180L));
        System.out.println("\u2705 OTP (fijo) asignado para " + request.identificacion() + ": " + otp + " (expira en 180 segundos)");
        return new OtpResponse("success", "OTP generado correctamente (modo prueba)", otp);
    }

    @Tool(description="Valida un OTP previamente generado para un usuario. Devuelve \u00e9xito si es correcto y no ha expirado.")
    public OtpResponse otp_validate(ValidateOtpRequest request) {
        String storedOtp = (String)this.otpStore.get(request.identificacion());
        Instant expiryTime = (Instant)this.otpExpiry.get(request.identificacion());
        if (storedOtp == null || expiryTime == null) {
            return new OtpResponse("error", "No se encontr\u00f3 OTP para este usuario", null);
        }
        if (Instant.now().isAfter(expiryTime)) {
            this.otpStore.remove(request.identificacion());
            this.otpExpiry.remove(request.identificacion());
            return new OtpResponse("error", "OTP expirado", request.otp());
        }
        if (storedOtp.equals(request.otp())) {
            this.otpStore.remove(request.identificacion());
            this.otpExpiry.remove(request.identificacion());
            return new OtpResponse("success", "OTP validado correctamente", request.otp());
        }
        return new OtpResponse("error", "OTP inv\u00e1lido", request.otp());
    }
}

