/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server;

import org.springframework.ai.mcp.sample.server.autenticacion.OtpToolService;
import org.springframework.ai.mcp.sample.server.tools.creditos.CreditoToolService;
import org.springframework.ai.mcp.sample.server.tools.inversiones.InversionToolService;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.method.MethodToolCallbackProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class McpServerApplication {
    public static void main(String[] args) {
        SpringApplication.run(McpServerApplication.class, (String[])args);
    }

    @Bean
    public ToolCallbackProvider authTools(OtpToolService otpToolService) {
        return MethodToolCallbackProvider.builder().toolObjects(new Object[]{otpToolService}).build();
    }

    @Bean
    public ToolCallbackProvider creditoTools(CreditoToolService creditoToolService) {
        return MethodToolCallbackProvider.builder().toolObjects(new Object[]{creditoToolService}).build();
    }

    @Bean
    public ToolCallbackProvider inversionTools(InversionToolService inversionToolService) {
        return MethodToolCallbackProvider.builder().toolObjects(new Object[]{inversionToolService}).build();
    }
}

