/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.ResponseModel;
import com.whatsapp.tws2.Repository.UserResponseRepository;
import com.whatsapp.tws2.service.UserResponseService;
import java.time.LocalDateTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class UserResponseServiceImpl
implements UserResponseService {
    private static final Logger log = LoggerFactory.getLogger(UserResponseServiceImpl.class);
    private final UserResponseRepository userResponseRepository;

    public Mono<Void> saveUserResponse(ResponseModel userResponse) {
        userResponse.setId(UUID.randomUUID().toString());
        userResponse.setCreatedAt(LocalDateTime.now());
        return this.userResponseRepository.save((Object)userResponse).doOnSuccess(response -> log.info("UserResponse saved: {}", response)).then().onErrorResume(error -> {
            log.error("Error saving UserResponse: {}", (Object)error.getMessage());
            return Mono.empty();
        });
    }

    public UserResponseServiceImpl(UserResponseRepository userResponseRepository) {
        this.userResponseRepository = userResponseRepository;
    }
}

