/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.CampaignModel;
import com.whatsapp.tws2.Documents.ResponseModel;
import com.whatsapp.tws2.Documents.StateConversation;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.Repository.Services.ConversationDAO;
import com.whatsapp.tws2.client.lhiaflow.LhiaFlowRequest;
import com.whatsapp.tws2.client.lhiaflow.service.ApiLhiaFLowService;
import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.UserResponse;
import com.whatsapp.tws2.data.state.UpdateStateConversationRequest;
import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.UserResponseService;
import com.whatsapp.tws2.service.WhatsappService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.ResponseUtil;
import com.whatsapp.tws2.utils.StatusUtil;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StateConversationServiceImpl
implements StateConversationService {
    private static final Logger log = LoggerFactory.getLogger(StateConversationServiceImpl.class);
    private final UserResponseService userResponseService;
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiWhatsAppService apiWhatsAppService;
    private final ConversationDAO conversationDAO;
    private final ResponseUtil responseUtil;
    private final Environment env;
    private final TsaApiService thinkAgentApiService;
    private final WhatsappService whatsappService;

    public Mono<String> getStatusCoonversation(String conversationId) {
        return this.conversationDAO.getStatusConversationByConversationId(conversationId);
    }

    public Mono<String> getCallbackIdFromConversationId(String conversationId) {
        return this.conversationDAO.getCallbackByConversationId(conversationId);
    }

    public Mono<String> validateAndUpdateChatFromApi(TextMessageRequest textMessageRequest) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        ResponseModel userMessage = new ResponseModel();
        userMessage.setBody((Object)textMessageRequest);
        userMessage.setFrom(textMessageRequest.getOrigin());
        return this.conversationDAO.existsByConversationId(textMessageRequest.getPhoneNumber()).flatMap(exists -> {
            if (!exists.booleanValue()) {
                return this.conversationDAO.save(new StateConversation(textMessageRequest.getPhoneNumber(), StatusUtil.ST_NORMAL, defaultCallback)).then(this.userResponseService.saveUserResponse(userMessage));
            }
            return this.userResponseService.saveUserResponse(userMessage);
        }).then(Mono.defer(() -> {
            if (textMessageRequest.getOrigin() != null && textMessageRequest.getChannel() != null) {
                String channel;
                switch (channel = textMessageRequest.getChannel().toLowerCase()) {
                    case "whatsapp": {
                        if (textMessageRequest.getMessage().toUpperCase().trim().startsWith("EL CHAT FUE CERRADO")) {
                            return this.validateAndUpdateChat(textMessageRequest.getPhoneNumber(), StatusUtil.ST_NORMAL, defaultCallback).then(Mono.just((Object)StatusUtil.ST_NORMAL));
                        }
                        return this.conversationDAO.getStatusConversationByConversationId(textMessageRequest.getPhoneNumber());
                    }
                }
                return Mono.just((Object)StatusUtil.ST_NORMAL);
            }
            return this.conversationDAO.getStatusConversationByConversationId(textMessageRequest.getPhoneNumber());
        }));
    }

    public Mono<Void> validateAndUpdateChatFromMetaTemplate(String conversationId, String canalCallback, String campaignMessage, String categoria) {
        log.info("Validando y actualizando conversaci\u00f3n: {}, estado: {}, callback: {}", new Object[]{conversationId, StatusUtil.ST_CAMPANA, canalCallback});
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_CAMPANA, canalCallback).then(Mono.fromRunnable(() -> {
            CampaignModel camp = new CampaignModel();
            camp.setConversationId(conversationId);
            camp.setMessageTemplate(campaignMessage);
            camp.setCategoria(categoria);
            camp.setCanal(canalCallback);
            camp.setSend(Boolean.valueOf(true));
            this.campaignMessageDAO.save(camp).subscribe();
        }));
    }

    public Mono<String> validateAndUpdateChatFromUserResponse(UserResponse userResponse) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        List from = ((UserResponse.Change)((UserResponse.Entry)userResponse.getEntry().get(0)).getChanges().get(0)).getValue().getContacts();
        ResponseModel response = new ResponseModel();
        response.setBody((Object)userResponse);
        response.setFrom(from == null ? "callbackSentMessage" : "user");
        return this.responseUtil.getMessage(userResponse).flatMap(data -> this.conversationDAO.existsByConversationId(data.getIdConversation()).flatMap(exists -> {
            if (!exists.booleanValue()) {
                return this.conversationDAO.save(new StateConversation(data.getIdConversation(), StatusUtil.ST_NORMAL, defaultCallback)).thenReturn(data);
            }
            return Mono.just((Object)data);
        })).flatMap(data -> {
            if (data != null && data.getMessage() != null) {
                String message = data.getMessage().replaceAll(" ", "").toUpperCase();
                if (message.equals(StatusUtil.ST_ASESOR)) {
                    return this.getCallbackIdFromConversationId(data.getIdConversation()).flatMap(callbackId -> {
                        String asesorState = callbackId.startsWith(this.env.getProperty("tsa.canal.prefix")) ? StatusUtil.ST_THINKAGENT : StatusUtil.ST_ASESOR;
                        return this.validateAndUpdateChat(data.getIdConversation(), asesorState, null).then(this.apiWhatsAppService.markMessageAsRead(data.getMessageId())).then(Mono.just((Object)asesorState));
                    });
                }
                if (message.equals(StatusUtil.ST_LHIA)) {
                    return this.validateAndUpdateChat(data.getIdConversation(), StatusUtil.ST_LHIA, null).then(this.apiWhatsAppService.markMessageAsRead(data.getMessageId())).then(Mono.just((Object)StatusUtil.ST_LHIA));
                }
                if (message.equals(StatusUtil.ST_FINALIZAR)) {
                    return this.validateAndUpdateChat(data.getIdConversation(), StatusUtil.ST_NORMAL, null).then(this.apiWhatsAppService.markMessageAsRead(data.getMessageId())).then(Mono.just((Object)StatusUtil.ST_NORMAL));
                }
                if (message.toUpperCase().contains("POR FAVOR CALIFICA ESTA CONVERSACI") || message.toUpperCase().contains("EL CHAT FUE CERRADO")) {
                    return this.validateAndUpdateChat(data.getIdConversation(), StatusUtil.ST_NORMAL, null).then(this.apiWhatsAppService.markMessageAsRead(data.getMessageId())).then(Mono.just((Object)StatusUtil.ST_NORMAL));
                }
            }
            System.out.println(" \n\n\nmessage: " + data);
            return this.conversationDAO.getStatusConversationByConversationId(data.getIdConversation());
        });
    }

    public Mono<Void> validateStateAsesor(String conversationId) {
        return this.getStatusCoonversation(conversationId).flatMap(status -> {
            if (!status.equals(StatusUtil.ST_ASESOR)) {
                return this.getCallbackIdFromConversationId(conversationId).flatMap(callbackId -> this.validateAndUpdateChat(conversationId, StatusUtil.ST_ASESOR, callbackId).then());
            }
            return Mono.empty();
        });
    }

    public Mono<Void> updateStateByConversationId(String conversationId, String state) {
        return this.getStatusCoonversation(conversationId).flatMap(status -> this.getCallbackIdFromConversationId(conversationId).flatMap(callbackId -> this.validateAndUpdateChat(conversationId, state, callbackId).then()));
    }

    public Mono<Void> validateAndUpdateChat(String conversationId, String stateConversation, String callback) {
        log.info("VOLVIENDO A ESTADO: {} CONVERSACION ID: {}", (Object)stateConversation, (Object)conversationId);
        return this.conversationDAO.existsByConversationId(conversationId).flatMap(exists -> {
            log.warn("estado: {}", exists);
            if (exists.booleanValue()) {
                return this.conversationDAO.findByConversationId(conversationId).flatMap(conversation -> {
                    conversation.setActive(Boolean.valueOf(true));
                    conversation.setStateConversation(stateConversation);
                    conversation.setUpdatedAt(LocalDateTime.now());
                    if (callback != null) {
                        conversation.setCallbackId(callback);
                    }
                    return this.conversationDAO.save(conversation).then();
                });
            }
            StateConversation newConversation = callback == null ? new StateConversation(conversationId, stateConversation) : new StateConversation(conversationId, stateConversation, callback);
            return this.conversationDAO.save(newConversation).then();
        });
    }

    public Mono<Void> updateStateCloseConversation(String conversationId) {
        log.info("Cerrando conversaci\u00f3n: {}", (Object)conversationId);
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, null);
    }

    public Mono<Void> updateStateConversation(UpdateStateConversationRequest body) {
        String conversationId = body.getConversationId();
        String event = body.getEvent();
        String callback = body.getCallbackId() == null ? this.env.getProperty("tsa.canal.callback.default") : body.getCallbackId();
        String nick = body.getNick() == null ? "Desconocido" : body.getNick();
        String initialMessage = body.getInitialMessage() == null || body.getInitialMessage().isBlank() ? "Hola" : body.getInitialMessage();
        log.info("Actualizando conversaci\u00f3n: {}, estado: {}, callback: {}", new Object[]{conversationId, event, callback});
        RequestMessageModel messageModelTSA = new RequestMessageModel(conversationId, MessageTypeUtils.TYPE_MESSAGE, nick, MessageTypeUtils.TYPE_TEXT, initialMessage, null);
        switch (event = event.toUpperCase().trim().replace(" ", "")) {
            case "BOT": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, callback);
            }
            case "NORMAL": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, callback);
            }
            case "ASESOR": {
                if (callback.startsWith("TWS")) {
                    return this.validateAndUpdateChat(conversationId, StatusUtil.ST_THINKAGENT, callback).then(this.thinkAgentApiService.sendMesssageToAsesor(messageModelTSA, callback).then());
                }
                LhiaFlowRequest req = new LhiaFlowRequest();
                req.setChannel("whatsapp");
                req.setMessage(initialMessage);
                req.setCallbackId(callback);
                req.setConversationChatId(conversationId);
                req.setType("text");
                req.setNick(nick);
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_ASESOR, callback).then(this.apiLhiaFLowService.sendMesssageToAsesor(req).then());
            }
            case "LHIA": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_LHIA, callback);
            }
            case "CAMPANA": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_CAMPANA, callback);
            }
        }
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_THINKAGENT, callback).then(this.thinkAgentApiService.sendMesssageToAsesor(messageModelTSA, callback)).then(this.whatsappService.sendTextMessage(conversationId, "Gracias por usar Lhia.\n\nEn un momento un asesor se pondr\u00e1 en contacto contigo.")).then();
    }

    public UserResponseService getUserResponseService() {
        return this.userResponseService;
    }

    public ApiLhiaFLowService getApiLhiaFLowService() {
        return this.apiLhiaFLowService;
    }

    public CampaignMessageDAO getCampaignMessageDAO() {
        return this.campaignMessageDAO;
    }

    public ApiWhatsAppService getApiWhatsAppService() {
        return this.apiWhatsAppService;
    }

    public ConversationDAO getConversationDAO() {
        return this.conversationDAO;
    }

    public ResponseUtil getResponseUtil() {
        return this.responseUtil;
    }

    public Environment getEnv() {
        return this.env;
    }

    public TsaApiService getThinkAgentApiService() {
        return this.thinkAgentApiService;
    }

    public WhatsappService getWhatsappService() {
        return this.whatsappService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateConversationServiceImpl)) {
            return false;
        }
        StateConversationServiceImpl other = (StateConversationServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UserResponseService this$userResponseService = this.getUserResponseService();
        UserResponseService other$userResponseService = other.getUserResponseService();
        if (this$userResponseService == null ? other$userResponseService != null : !this$userResponseService.equals(other$userResponseService)) {
            return false;
        }
        ApiLhiaFLowService this$apiLhiaFLowService = this.getApiLhiaFLowService();
        ApiLhiaFLowService other$apiLhiaFLowService = other.getApiLhiaFLowService();
        if (this$apiLhiaFLowService == null ? other$apiLhiaFLowService != null : !this$apiLhiaFLowService.equals(other$apiLhiaFLowService)) {
            return false;
        }
        CampaignMessageDAO this$campaignMessageDAO = this.getCampaignMessageDAO();
        CampaignMessageDAO other$campaignMessageDAO = other.getCampaignMessageDAO();
        if (this$campaignMessageDAO == null ? other$campaignMessageDAO != null : !this$campaignMessageDAO.equals(other$campaignMessageDAO)) {
            return false;
        }
        ApiWhatsAppService this$apiWhatsAppService = this.getApiWhatsAppService();
        ApiWhatsAppService other$apiWhatsAppService = other.getApiWhatsAppService();
        if (this$apiWhatsAppService == null ? other$apiWhatsAppService != null : !this$apiWhatsAppService.equals(other$apiWhatsAppService)) {
            return false;
        }
        ConversationDAO this$conversationDAO = this.getConversationDAO();
        ConversationDAO other$conversationDAO = other.getConversationDAO();
        if (this$conversationDAO == null ? other$conversationDAO != null : !this$conversationDAO.equals(other$conversationDAO)) {
            return false;
        }
        ResponseUtil this$responseUtil = this.getResponseUtil();
        ResponseUtil other$responseUtil = other.getResponseUtil();
        if (this$responseUtil == null ? other$responseUtil != null : !this$responseUtil.equals(other$responseUtil)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        TsaApiService this$thinkAgentApiService = this.getThinkAgentApiService();
        TsaApiService other$thinkAgentApiService = other.getThinkAgentApiService();
        if (this$thinkAgentApiService == null ? other$thinkAgentApiService != null : !this$thinkAgentApiService.equals(other$thinkAgentApiService)) {
            return false;
        }
        WhatsappService this$whatsappService = this.getWhatsappService();
        WhatsappService other$whatsappService = other.getWhatsappService();
        return !(this$whatsappService == null ? other$whatsappService != null : !this$whatsappService.equals(other$whatsappService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateConversationServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserResponseService $userResponseService = this.getUserResponseService();
        result = result * 59 + ($userResponseService == null ? 43 : $userResponseService.hashCode());
        ApiLhiaFLowService $apiLhiaFLowService = this.getApiLhiaFLowService();
        result = result * 59 + ($apiLhiaFLowService == null ? 43 : $apiLhiaFLowService.hashCode());
        CampaignMessageDAO $campaignMessageDAO = this.getCampaignMessageDAO();
        result = result * 59 + ($campaignMessageDAO == null ? 43 : $campaignMessageDAO.hashCode());
        ApiWhatsAppService $apiWhatsAppService = this.getApiWhatsAppService();
        result = result * 59 + ($apiWhatsAppService == null ? 43 : $apiWhatsAppService.hashCode());
        ConversationDAO $conversationDAO = this.getConversationDAO();
        result = result * 59 + ($conversationDAO == null ? 43 : $conversationDAO.hashCode());
        ResponseUtil $responseUtil = this.getResponseUtil();
        result = result * 59 + ($responseUtil == null ? 43 : $responseUtil.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        TsaApiService $thinkAgentApiService = this.getThinkAgentApiService();
        result = result * 59 + ($thinkAgentApiService == null ? 43 : $thinkAgentApiService.hashCode());
        WhatsappService $whatsappService = this.getWhatsappService();
        result = result * 59 + ($whatsappService == null ? 43 : $whatsappService.hashCode());
        return result;
    }

    public String toString() {
        return "StateConversationServiceImpl(userResponseService=" + this.getUserResponseService() + ", apiLhiaFLowService=" + this.getApiLhiaFLowService() + ", campaignMessageDAO=" + this.getCampaignMessageDAO() + ", apiWhatsAppService=" + this.getApiWhatsAppService() + ", conversationDAO=" + this.getConversationDAO() + ", responseUtil=" + this.getResponseUtil() + ", env=" + this.getEnv() + ", thinkAgentApiService=" + this.getThinkAgentApiService() + ", whatsappService=" + this.getWhatsappService() + ")";
    }

    public StateConversationServiceImpl(UserResponseService userResponseService, ApiLhiaFLowService apiLhiaFLowService, CampaignMessageDAO campaignMessageDAO, ApiWhatsAppService apiWhatsAppService, ConversationDAO conversationDAO, ResponseUtil responseUtil, Environment env, TsaApiService thinkAgentApiService, WhatsappService whatsappService) {
        this.userResponseService = userResponseService;
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.apiWhatsAppService = apiWhatsAppService;
        this.conversationDAO = conversationDAO;
        this.responseUtil = responseUtil;
        this.env = env;
        this.thinkAgentApiService = thinkAgentApiService;
        this.whatsappService = whatsappService;
    }
}

