/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.data.ButtonReply;
import com.whatsapp.tws2.data.ResponseLhia;
import com.whatsapp.tws2.service.ButtonBuilderMetaService;
import com.whatsapp.tws2.utils.BuildButtonUtils;
import com.whatsapp.tws2.utils.BuildLhiaMessageUtils;
import com.whatsapp.tws2.utils.EventLhiaEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ButtonBuilderMetaServiceImpl
implements ButtonBuilderMetaService {
    private static final Logger log = LoggerFactory.getLogger(ButtonBuilderMetaServiceImpl.class);

    public Map<String, Object> generateListButtonFromEvent(List<String> events, String phoneNumber, String titleEvent) {
        if (events == null) {
            return null;
        }
        log.info("evento: {}", events);
        ArrayList<ButtonReply> listButtons = new ArrayList<ButtonReply>();
        for (String evt : events) {
            ButtonReply btn;
            String description;
            if (evt.equals(EventLhiaEnum.VER_CARRITO.getKey())) {
                description = EventLhiaEnum.VER_CARRITO.getDescription();
                btn = BuildButtonUtils.generateButton((String)evt, (String)description);
                listButtons.add(btn);
            }
            if (evt.equals(EventLhiaEnum.COMPRAR.getKey())) {
                description = EventLhiaEnum.COMPRAR.getDescription();
                btn = BuildButtonUtils.generateButton((String)evt, (String)description);
                listButtons.add(btn);
            }
            if (evt.equals(EventLhiaEnum.AGREGAR_PRODUCTO.getKey())) {
                description = EventLhiaEnum.AGREGAR_PRODUCTO.getDescription();
                btn = BuildButtonUtils.generateButton((String)evt, (String)description);
                listButtons.add(btn);
            }
            if (!evt.equals(EventLhiaEnum.FINALIZAR.getKey())) continue;
            description = EventLhiaEnum.FINALIZAR.getDescription();
            btn = BuildButtonUtils.generateButton((String)evt, (String)description);
            listButtons.add(btn);
        }
        if (!listButtons.isEmpty()) {
            return BuildButtonUtils.createInteractiveMessage((String)phoneNumber, (String)titleEvent, listButtons);
        }
        return null;
    }

    public Map<String, Object> generateButtonFromEvent(String event, String phoneNumber) {
        log.info("evento: {}", (Object)event);
        if (event.equals(EventLhiaEnum.VER_CARRITO.getKey())) {
            List listButtons = BuildButtonUtils.generateOneButton((String)event, (String)event);
            return BuildButtonUtils.createInteractiveMessage((String)phoneNumber, (String)EventLhiaEnum.VER_CARRITO.getTitle(), (List)listButtons);
        }
        if (event.equals(EventLhiaEnum.AGREGAR_PRODUCTO.getKey())) {
            String eventButton = EventLhiaEnum.AGREGAR_PRODUCTO.getDescription();
            List listButtons = BuildButtonUtils.generateOneButton((String)event, (String)eventButton);
            return BuildButtonUtils.createInteractiveMessage((String)phoneNumber, (String)EventLhiaEnum.AGREGAR_PRODUCTO.getTitle(), (List)listButtons);
        }
        return null;
    }

    public Map<String, Object> generateButtonFromEventProduct(ResponseLhia.Product product, String event, String phoneNumber) {
        log.info("evento: {}", (Object)event);
        Map header = BuildButtonUtils.GenerateImageHeader((String)product.getImagenUrl());
        String productBody = BuildLhiaMessageUtils.captionListProductsDetail((ResponseLhia.Product)product);
        if (event.equals(EventLhiaEnum.VER_CARRITO.getKey())) {
            List listButtons = BuildButtonUtils.generateOneButton((String)event, (String)event);
            return BuildButtonUtils.createInteractiveMessageWithHeader((String)phoneNumber, (String)productBody, (List)listButtons, (Map)header);
        }
        if (event.equals(EventLhiaEnum.AGREGAR_PRODUCTO.getKey())) {
            String eventButton = EventLhiaEnum.AGREGAR_PRODUCTO.getDescription();
            List listButtons = BuildButtonUtils.generateOneButton((String)event, (String)eventButton);
            return BuildButtonUtils.createInteractiveMessageWithHeader((String)phoneNumber, (String)productBody, (List)listButtons, (Map)header);
        }
        return null;
    }

    public Map<String, Object> generateButtonFromProductWithCaptionAndButton(ResponseLhia.Product product, String phoneNumber) {
        log.info("lista de productos: {}, {}", (Object)phoneNumber, (Object)product);
        String codeEventProduct = EventLhiaEnum.ADD_CART_CODE.getKey().replace("{CODE}", String.valueOf(product.getId()));
        List listButtons = BuildButtonUtils.generateOneButton((String)codeEventProduct, (String)EventLhiaEnum.ADD_CART_CODE.getTitle());
        Map header = BuildButtonUtils.GenerateImageHeader((String)product.getImagenUrl());
        return BuildButtonUtils.createInteractiveMessageWithHeader((String)phoneNumber, (String)BuildLhiaMessageUtils.captionListProductsDetail((ResponseLhia.Product)product), (List)listButtons, (Map)header);
    }

    public Map<String, Object> generateOneButton(String buttonId, String buttonTitle, String phoneNumber, String buttonText) {
        List listButtons = BuildButtonUtils.generateOneButton((String)buttonId, (String)buttonTitle);
        return BuildButtonUtils.createInteractiveMessage((String)phoneNumber, (String)buttonText, (List)listButtons);
    }
}

