/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.data.templatesMeta;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.whatsapp.tws2.data.campaigns.whatsapp.ComponentWhatsapp;
import com.whatsapp.tws2.data.campaigns.whatsapp.ParameterWhatsApp;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplateRequest;
import com.whatsapp.tws2.utils.Utils;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WhatsAppTemplateRequest {
    private String number;
    private String templateName;
    private String language;
    private Header header;
    private Body body;
    private String canal;
    private String template;
    private String categoria;

    public ComponentWhatsapp generarBodyComponent(Body body) {
        if (body == null || body.getType() == null || body.getParameters() == null || body.getParameters().isEmpty()) {
            return null;
        }
        ComponentWhatsapp component = new ComponentWhatsapp();
        component.setType(body.getType());
        List scapedParameters = body.getParameters().stream().map(param -> new BodyParameter(param.getType(), Utils.cleanString((String)param.getText()))).collect(Collectors.toList());
        for (BodyParameter parameter : scapedParameters) {
            if (parameter.getType() == null || !parameter.getType().equals("text")) continue;
            if (parameter.getText() == null) {
                return null;
            }
            ParameterWhatsApp parameterWhatsApp = new ParameterWhatsApp(parameter.getType(), (Object)parameter.getText());
            component.getParameters().add(parameterWhatsApp);
        }
        return component;
    }

    public ComponentWhatsapp generarHeaderComponent(Header header) {
        if (header == null || header.getType() == null || header.getParameters() == null || header.getParameters().isEmpty()) {
            return null;
        }
        ComponentWhatsapp component = new ComponentWhatsapp();
        component.setType(header.getType());
        for (Parameter parameter : header.getParameters()) {
            ParameterWhatsApp parameterWhatsApp;
            if (parameter.getType() != null && parameter.getType().equals("image")) {
                if (parameter.getImage() == null) {
                    return null;
                }
                parameterWhatsApp = new ParameterWhatsApp(parameter.getType(), (Object)parameter.getImage());
                component.getParameters().add(parameterWhatsApp);
            }
            if (parameter.getType() == null || !parameter.getType().equals("text")) continue;
            if (parameter.getText() == null) {
                return null;
            }
            parameterWhatsApp = new ParameterWhatsApp(parameter.getType(), (Object)parameter.getText());
            component.getParameters().add(parameterWhatsApp);
        }
        return component;
    }

    public String getNumber() {
        return this.number;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getLanguage() {
        return this.language;
    }

    public Header getHeader() {
        return this.header;
    }

    public Body getBody() {
        return this.body;
    }

    public String getCanal() {
        return this.canal;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getCategoria() {
        return this.categoria;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setCanal(String canal) {
        this.canal = canal;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setCategoria(String categoria) {
        this.categoria = categoria;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhatsAppTemplateRequest)) {
            return false;
        }
        WhatsAppTemplateRequest other = (WhatsAppTemplateRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$canal = this.getCanal();
        String other$canal = other.getCanal();
        if (this$canal == null ? other$canal != null : !this$canal.equals(other$canal)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$categoria = this.getCategoria();
        String other$categoria = other.getCategoria();
        return !(this$categoria == null ? other$categoria != null : !this$categoria.equals(other$categoria));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhatsAppTemplateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $canal = this.getCanal();
        result = result * 59 + ($canal == null ? 43 : $canal.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $categoria = this.getCategoria();
        result = result * 59 + ($categoria == null ? 43 : $categoria.hashCode());
        return result;
    }

    public String toString() {
        return "WhatsAppTemplateRequest(number=" + this.getNumber() + ", templateName=" + this.getTemplateName() + ", language=" + this.getLanguage() + ", header=" + this.getHeader() + ", body=" + this.getBody() + ", canal=" + this.getCanal() + ", template=" + this.getTemplate() + ", categoria=" + this.getCategoria() + ")";
    }

    public WhatsAppTemplateRequest() {
    }

    public WhatsAppTemplateRequest(String number, String templateName, String language, Header header, Body body, String canal, String template, String categoria) {
        this.number = number;
        this.templateName = templateName;
        this.language = language;
        this.header = header;
        this.body = body;
        this.canal = canal;
        this.template = template;
        this.categoria = categoria;
    }
}

