/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Documents.CampaignModel;
import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Documents.ImagenModel;
import com.whatsapp.tws2.client.lhiaflow.MarcimexCallbackResponse;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ConversationSummaryResponse;
import com.whatsapp.tws2.data.DateConversation;
import com.whatsapp.tws2.data.FileMessageRequestFromHiper;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplate;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplateRequest;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.TemplateService;
import com.whatsapp.tws2.utils.StatusUtil;
import com.whatsapp.tws2.web.service.WebChannelService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api"})
public class WhatsappController {
    private static final Logger log = LoggerFactory.getLogger(WhatsappController.class);
    private final StateConversationService stateConversationService;
    private final Environment env;
    private final ApiWhatsAppService whatsAppService;
    private final TemplateService templateService;
    private final ObjectMapper mapper;
    private final HistoryConversationItemService historyConversationService;
    private final WebChannelService webChannelService;

    @PostMapping(value={"/asesor"})
    public Mono<Void> receiveTemplateMessage(@RequestBody Object request) {
        log.info("Sending message from lhiaflow {}", request);
        String defaultCallback = this.env.getProperty("lhiaflow.callback.atencion");
        MarcimexCallbackResponse obj = (MarcimexCallbackResponse)this.mapper.convertValue(request, MarcimexCallbackResponse.class);
        String channel = "whatsapp";
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(obj.getConversationId(), channel, (String)(obj.getType().equals("text") ? obj.getPayload().getText() : "Archivo de tipo [" + obj.getType() + "]"), "ASESOR", "ASESOR", "User");
        if (obj.getChannel() != null && obj.getChannel().equalsIgnoreCase("WEB")) {
            return this.historyConversationService.save(userHistoryConversation).then(this.webChannelService.sendMessageToBotpressWeb(obj)).then();
        }
        if (obj.getType().equals("text")) {
            TextMessageRequest model = new TextMessageRequest();
            model.setChannel("whatsapp");
            model.setMessage(obj.getPayload().getText());
            model.setPhoneNumber(obj.getConversationId());
            if (model.getMessage().toUpperCase().contains("EL CHAT FUE CERRADO")) {
                return this.stateConversationService.validateAndUpdateChat(obj.getConversationId(), StatusUtil.ST_NORMAL, defaultCallback).then(this.sendTextMessage(model)).then(this.historyConversationService.save(userHistoryConversation)).doOnError(error -> log.error("ERROR AL ENVIAR MENSAJES: ", error)).then();
            }
            return this.sendTextMessage(model).then(this.historyConversationService.save(userHistoryConversation)).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).doOnError(error -> log.error("ERROR AL ENVIAR MENSAJES: ", error)).then();
        }
        if (obj.getType().equals("image")) {
            FileMessageRequestFromHiper model = new FileMessageRequestFromHiper();
            model.setCaption("imagen");
            model.setFileUrl(obj.getPayload().getUrl());
            model.setPhoneNumber(obj.getConversationId());
            return this.sendImageMessageReactive(model).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).then(this.historyConversationService.save(userHistoryConversation)).then();
        }
        if (obj.getType().equals("video")) {
            FileMessageRequestFromHiper model = new FileMessageRequestFromHiper();
            model.setCaption("video");
            model.setFileUrl(obj.getPayload().getUrl());
            model.setPhoneNumber(obj.getConversationId());
            return this.sendVideoMessageReactive(model).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).then(this.historyConversationService.save(userHistoryConversation)).doOnError(error -> log.error("ERROR AL ENVIAR VIDEOS: ", error)).then();
        }
        if (obj.getType().equals("file")) {
            FileMessageRequestFromHiper model = new FileMessageRequestFromHiper();
            model.setCaption("document");
            model.setFileUrl(obj.getPayload().getUrl());
            model.setPhoneNumber(obj.getConversationId());
            return this.sendDocumentMessageReactive(model).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).then(this.historyConversationService.save(userHistoryConversation)).doOnError(error -> log.error("ERROR AL ENVIAR VIDEOS: ", error)).then();
        }
        HashMap<String, String> successResponse = new HashMap<String, String>();
        successResponse.put("status", "success");
        return Mono.empty();
    }

    @GetMapping(value={"/test"})
    public Mono<?> test() {
        HashMap<String, String> successResponse = new HashMap<String, String>();
        log.info("ENTRA AL SERVICIO CONSULTADO");
        successResponse.put("status", "success");
        return Mono.just(successResponse);
    }

    @PostMapping(value={"/send-message"})
    public Mono<ResponseEntity<Map<String, Object>>> sendTextMessageTestHiper(@RequestBody TextMessageRequest req) {
        log.info("Sending message from hiper {}", (Object)req.getPhoneNumber());
        return this.stateConversationService.validateAndUpdateChatFromApi(req).doOnNext(estado -> log.warn("\n\n\nEstado de la conversaci\u00f3n: " + estado + "\n\n\n")).flatMap(estado -> this.whatsAppService.sendTextMessage(req)).map(response -> {
            HashMap<String, String> successResponse = new HashMap<String, String>();
            successResponse.put("status", "success");
            successResponse.put("message", "Mensaje de texto enviado correctamente.");
            return ResponseEntity.ok(successResponse);
        }).onErrorResume(e -> {
            log.error("Failed to send text message: {}", (Object)e.getMessage());
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("status", "error");
            errorResponse.put("error", "Error al enviar el mensaje, contacte al administrador.");
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse));
        });
    }

    @PostMapping(value={"/sendText"})
    public Mono<ResponseEntity<String>> sendTextMessage(@RequestBody TextMessageRequest req) {
        log.info("Req on controller {}", (Object)req.getPhoneNumber());
        return this.stateConversationService.validateAndUpdateChatFromApi(req).doOnNext(estado -> log.warn("Estado de la conversaci\u00f3n: {}", estado)).flatMap(estado -> this.whatsAppService.sendTextMessage(req)).map(response -> ResponseEntity.ok((Object)"Text message sent successfully!")).onErrorResume(e -> {
            log.error("Failed to send template message ", e);
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send text message"));
        });
    }

    @PostMapping(value={"/sendImage"})
    public Mono<ResponseEntity<String>> sendImageMessageReactive(@RequestBody FileMessageRequestFromHiper imageMessageRequest) {
        return this.whatsAppService.sendImageMessage(imageMessageRequest).map(response -> ResponseEntity.ok((Object)"Image message sent successfully!")).onErrorResume(e -> {
            System.out.println("Failed to send image message: " + e.getMessage());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send image message"));
        });
    }

    @PostMapping(value={"/sendVideo"})
    public Mono<ResponseEntity<String>> sendVideoMessageReactive(@RequestBody FileMessageRequestFromHiper imageMessageRequest) {
        return this.whatsAppService.sendVideoMessage(imageMessageRequest).map(response -> ResponseEntity.ok((Object)"Video message sent successfully!")).onErrorResume(e -> {
            System.out.println("Failed to send image message: " + e.getMessage());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send image message"));
        });
    }

    @PostMapping(value={"/sendDocument"})
    public Mono<ResponseEntity<String>> sendDocumentMessageReactive(@RequestBody FileMessageRequestFromHiper imageMessageRequest) {
        return this.whatsAppService.sendDocumentMessage(imageMessageRequest).map(response -> ResponseEntity.ok((Object)"Document message sent successfully!")).onErrorResume(e -> {
            System.out.println("Failed to send image message: " + e.getMessage());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send image message"));
        });
    }

    @GetMapping(value={"/templates"})
    public Mono<List<WhatsAppTemplate>> getTemplates() throws Exception {
        return this.templateService.getTemplates();
    }

    @GetMapping(value={"/templates/{id}"})
    public Mono<WhatsAppTemplate> getTemplateById(@PathVariable(value="id", required=true) String id) {
        return this.templateService.getTemplateById(id);
    }

    @PostMapping(value={"/send-template"})
    public Mono<Void> sendTemplate(@RequestBody WhatsAppTemplateRequest request) {
        return this.templateService.sendMessageFromTemplate(request);
    }

    @PostMapping(value={"/analytics-conversation"}, produces={"application/json"})
    public Mono<ConversationSummaryResponse> getConversationSummary(@RequestBody DateConversation dateConversation) {
        return this.templateService.getConversationSummary(dateConversation.getFecha_inicio(), dateConversation.getFecha_fin());
    }

    @GetMapping(value={"/conversations-incidents"})
    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.templateService.getAllConversationIncident();
    }

    @PostMapping(value={"/imagen-url"})
    public Mono<ImagenModel> guardarImagen(@RequestBody ImagenModel body) {
        return this.templateService.guardarUrlImagen(body.getIdImagen(), body.getUrlImagen());
    }

    @GetMapping(value={"/imagen-url/{id}"})
    public Mono<String> obtenerImagen(@PathVariable String id) {
        return this.templateService.obtenerIdImagen(id);
    }

    public WhatsappController(StateConversationService stateConversationService, Environment env, ApiWhatsAppService whatsAppService, TemplateService templateService, ObjectMapper mapper, HistoryConversationItemService historyConversationService, WebChannelService webChannelService) {
        this.stateConversationService = stateConversationService;
        this.env = env;
        this.whatsAppService = whatsAppService;
        this.templateService = templateService;
        this.mapper = mapper;
        this.historyConversationService = historyConversationService;
        this.webChannelService = webChannelService;
    }
}

