/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.botpress.service.ApiBotpressService;
import com.whatsapp.tws2.client.lhia.service.ApiLhiaService;
import com.whatsapp.tws2.client.lhiaflow.LhiaFlowRequest;
import com.whatsapp.tws2.client.lhiaflow.service.ApiLhiaFLowService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.UserResponse;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.LhiaProcessService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.ResponseUtil;
import com.whatsapp.tws2.utils.StatusUtil;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"webhook"})
public class WebhookController {
    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    private final StateConversationService stateConversationService;
    private final Environment env;
    private final ApiBotpressService apiBotpressService;
    private final ObjectMapper objectMapper;
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final ResponseUtil responseUtil;
    private final ApiLhiaService apiLhiaService;
    private final LhiaProcessService lhiaProcessService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiWhatsAppService whatsAppService;
    private final HistoryConversationItemService historyConversationService;
    private final ThinkAgentService thinkAgentService;

    @GetMapping(value={""})
    public Mono<ResponseEntity<String>> verifyWebhook(@RequestParam(name="hub.verify_token", required=false) String verifyToken, @RequestParam(name="hub.challenge", required=false) String challenge) {
        log.info("Verificando webhook con token: {} y challenge: {}", (Object)verifyToken, (Object)challenge);
        String VERIFY_TOKEN = this.env.getProperty("whatsapp.verify.token");
        if (VERIFY_TOKEN.equals(verifyToken)) {
            return Mono.just((Object)new ResponseEntity((Object)challenge, (HttpStatusCode)HttpStatus.OK));
        }
        log.error("Error de verificaci\u00f3n: token no coincide");
        return Mono.just((Object)new ResponseEntity((Object)"Error de verificaci\u00f3n", (HttpStatusCode)HttpStatus.FORBIDDEN));
    }

    @PostMapping(value={"/test"})
    public Mono<String> testcallback(@RequestBody Object body) {
        log.info("test hook {}", body);
        return Mono.just((Object)"");
    }

    @PostMapping(value={"/hook"})
    public Mono<ResponseEntity<?>> handleWebhookTest(@RequestBody Object body) {
        log.info("test hook {}", body);
        return this.apiBotpressService.notifyWebHook(body).then().map(res -> ResponseEntity.ok((Object)res));
    }

    private Mono<ResponseEntity<?>> flujoAsesor(UserResponse userBody, String defaultCallback, String estado) {
        return this.responseUtil.getMessage(userBody).flatMap(usrBody -> {
            log.info("WEBHOOK DATA {}", usrBody);
            return this.stateConversationService.getCallbackIdFromConversationId(usrBody.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                LhiaFlowRequest messageModel = new LhiaFlowRequest();
                messageModel.setChannel(usrBody.getCanal());
                messageModel.setConversationChatId(usrBody.getIdConversation());
                messageModel.setNick(usrBody.getNick());
                messageModel.setMessage(usrBody.getMessage());
                messageModel.setFile(usrBody.getFile());
                messageModel.setCallbackId(callbackId == null ? defaultCallback : callbackId);
                messageModel.setType(usrBody.getType());
                messageModel.setLongitude(usrBody.getLongitude());
                messageModel.setLatitude(usrBody.getLatitude());
                log.info("messageModel {}", (Object)messageModel);
                if (StatusUtil.ST_CAMPANA.equals(estado)) {
                    return this.campaignMessageDAO.findLastMessageTemplateByConversationId(usrBody.getIdConversation()).flatMap(message -> {
                        if (!message.isBlank()) {
                            String messageOriginal = messageModel.getMessage() == null ? "" : messageModel.getMessage();
                            String newMessageModified = "Msg usuario: " + messageOriginal + "\n;Campa\u00f1a: " + message;
                            messageModel.setMessage(newMessageModified);
                            log.warn("EL ESTADO ACTUAL ES: {}", (Object)messageModel.getMessage());
                            if (!messageModel.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                                LhiaFlowRequest textMessageModel = new LhiaFlowRequest();
                                textMessageModel.setChannel(messageModel.getChannel());
                                textMessageModel.setConversationChatId(messageModel.getConversationChatId());
                                textMessageModel.setNick(messageModel.getNick());
                                textMessageModel.setMessage("Campa\u00f1a: " + message);
                                textMessageModel.setCallbackId(messageModel.getCallbackId());
                                textMessageModel.setType(MessageTypeUtils.TYPE_TEXT);
                                return this.apiLhiaFLowService.sendMesssageToAsesor(textMessageModel).then(this.historyConversationService.saveHistoryConversations(textMessageModel, "USER")).then(this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).then(this.historyConversationService.saveHistoryConversations(messageModel, "USER")).then(this.stateConversationService.validateAndUpdateChat(messageModel.getConversationChatId(), StatusUtil.ST_ASESOR, callbackId)).map(res -> ResponseEntity.ok().build()));
                            }
                            return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).then(this.historyConversationService.saveHistoryConversations(messageModel, "USER")).then(this.stateConversationService.validateAndUpdateChat(messageModel.getConversationChatId(), StatusUtil.ST_ASESOR, callbackId)).map(res -> ResponseEntity.ok().build());
                        }
                        return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).map(res -> ResponseEntity.ok().build());
                    });
                }
                if (StatusUtil.ST_LHIA.equals(estado)) {
                    return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).defaultIfEmpty((Object)"").flatMap(data -> this.saveHistoryConversations(messageModel, data)).flatMap(result -> {
                        TextMessageRequest textMessagaReq = new TextMessageRequest(messageModel.getConversationChatId(), StatusUtil.MSG_NOTIFICACION_CLIENTE_ARCHIVOS_ASESOR);
                        return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(res -> {
                            log.info("Mensaje enviado a WhatsApp: {}", res);
                            return Mono.just((Object)ResponseEntity.ok().build());
                        });
                    });
                }
                return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).defaultIfEmpty((Object)"").flatMap(data -> this.saveHistoryConversations(messageModel, data)).flatMap(result -> {
                    String mensajeToAnalis;
                    String string = mensajeToAnalis = messageModel.getMessage() != null ? messageModel.getMessage().toUpperCase().replace(" ", "") : "";
                    if (mensajeToAnalis.equals(estado)) {
                        TextMessageRequest textMessagaReq = new TextMessageRequest(messageModel.getConversationChatId(), StatusUtil.MSG_SOLICITUD_ASESOR);
                        return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(res -> {
                            log.info("Mensaje enviado a WhatsApp: {}", res);
                            return Mono.just((Object)ResponseEntity.ok().build());
                        });
                    }
                    return Mono.just((Object)ResponseEntity.ok().build());
                }).doOnError(error -> log.error("Error occurred during message sending", error)).onErrorResume(error -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build()));
            });
        });
    }

    private Mono<ResponseEntity<?>> handleCampaignCase(ExtractData data) {
        log.info("CAMPA\u00d1A, data {}", (Object)data);
        return this.campaignMessageDAO.findLastMessageTemplateByConversationId(data.getIdConversation()).flatMap(campaignMessage -> {
            if (!campaignMessage.isBlank()) {
                String messageOriginal;
                Object newMessageModified = "";
                String string = messageOriginal = data.getMessage() == null ? "" : data.getMessage();
                if (!data.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                    ExtractData textMessageModel = new ExtractData(data);
                    newMessageModified = "*Msg usuario:* [Archivo adjunto en el siguiente mensaje]\n*Campa\u00f1a:* " + campaignMessage;
                    textMessageModel.setMessage((String)newMessageModified);
                    textMessageModel.setType(MessageTypeUtils.TYPE_TEXT);
                    log.warn("EL MENSAJE DE CAMPANA CON ARCHIVOS ES: {}", (Object)data.getMessage());
                    return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(textMessageModel).delayElement(Duration.ofSeconds(3L)).flatMap(res -> this.handleThinkAgentCase(data)));
                }
                newMessageModified = "*Msg usuario:* " + messageOriginal + "\n*Campa\u00f1a:* " + campaignMessage;
                data.setMessage((String)newMessageModified);
                log.warn("EL MENSAJE DE CAMPANA ES: {}", (Object)data.getMessage());
            }
            return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(data));
        });
    }

    private Mono<ResponseEntity<?>> handleThinkAgentCase(ExtractData data) {
        return this.thinkAgentService.sendMessageToTAS(data).map(res -> {
            log.info("THINKAGENT RESPONSE: {}", res);
            return ResponseEntity.ok().build();
        });
    }

    @PostMapping(value={"sendMessageToAsesorFromApiStatus"})
    public Mono<ResponseEntity<String>> sendMessagetoAsesorFromApi(@RequestBody LhiaFlowRequest body) {
        body.setCallbackId(this.env.getProperty("tsa.canal.callback.ventas"));
        return this.apiLhiaFLowService.sendMesssageToAsesor(body).defaultIfEmpty((Object)"").flatMap(data -> this.saveHistoryConversations(body, data)).flatMap(result -> {
            TextMessageRequest textMessagaReq = new TextMessageRequest(body.getConversationChatId(), StatusUtil.MSG_SOLICITUD_ASESOR);
            return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(res -> {
                log.info("Mensaje enviado a WhatsApp: {}", res);
                return Mono.just((Object)ResponseEntity.ok().body((Object)""));
            });
        }).doOnError(error -> log.error("Error occurred during message sending", error)).onErrorResume(error -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build()));
    }

    @PostMapping(value={""})
    public Mono<ResponseEntity<?>> handleWebhook(@RequestBody Object userResponse) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        return this.convertToUserResponse(userResponse).flatMap(userBody -> this.stateConversationService.validateAndUpdateChatFromUserResponse(userBody).flatMap(status -> {
            System.err.println("status> " + status);
            this.responseUtil.getMessage(userBody).flatMap(dataMessage -> {
                HistoryConversationItem historyConversationItem = new HistoryConversationItem(dataMessage.getIdConversation(), dataMessage.getCanal(), dataMessage.getMessage(), dataMessage.getMessageId(), StatusUtil.ROL_USER, status, dataMessage.getNick());
                return this.historyConversationService.save(historyConversationItem);
            }).subscribe();
            switch (status) {
                case "NORMAL": {
                    return this.responseUtil.getMessage(userBody).flatMap(data -> {
                        String message;
                        log.info("WEBHOOK DATA {}", data);
                        if (data != null && data.getMessage() != null && (message = data.getMessage().replaceAll(" ", "").toUpperCase()).equals(StatusUtil.ST_FINALIZAR)) {
                            data.setButtonId(StatusUtil.ST_FINALIZAR);
                            return this.lhiaProcessService.sendMessageLhiaSwitch(data).map(res -> ResponseEntity.ok().build());
                        }
                        if (data != null && data.getMessage() != null && (message = data.getMessage().replaceAll(" ", "").toUpperCase()).contains("EL CHAT FUE CERRADO")) {
                            data.setButtonId(StatusUtil.ST_FINALIZAR);
                            return this.lhiaProcessService.sendMessageLhiaSwitch(data).map(res -> ResponseEntity.ok().build());
                        }
                        return this.apiBotpressService.notifyWebHook(userResponse).map(res -> ResponseEntity.ok().build());
                    });
                }
                case "ASESOR": {
                    log.info("user body {}", userBody);
                    return this.flujoAsesor(userBody, defaultCallback, StatusUtil.ST_ASESOR);
                }
                case "CAMPANA": {
                    return this.responseUtil.getMessage(userBody).flatMap(data -> this.stateConversationService.getCallbackIdFromConversationId(data.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                        if (callbackId.startsWith(this.env.getProperty("tsa.canal.prefix"))) {
                            return this.handleCampaignCase(data);
                        }
                        return this.flujoAsesor(userBody, callbackId, StatusUtil.ST_CAMPANA);
                    }));
                }
                case "LHIA": {
                    return this.responseUtil.getMessage(userBody).flatMap(body -> {
                        log.info("WEBHOOK DATA TO LHIA {}", body);
                        if (body.getType().equals(MessageTypeUtils.TYPE_TEXT) || body.getType().equals(MessageTypeUtils.TYPE_INTERACTIVE)) {
                            log.info("IS A TEXT OR INTERACTIVE MESSAGE TO LHIA");
                            return this.lhiaProcessService.sendMessageLhiaSwitch(body).map(res -> ResponseEntity.ok().build());
                        }
                        return this.flujoAsesor(userBody, defaultCallback, StatusUtil.ST_LHIA);
                    });
                }
                case "THINKAGENT": {
                    return this.responseUtil.getMessage(userBody).flatMap(body -> this.thinkAgentService.sendMessageToTAS(body).flatMap(res -> {
                        log.info("THINKAGENT RESPONSE {}", res);
                        return Mono.just((Object)ResponseEntity.ok().build());
                    }));
                }
            }
            return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
        })).onErrorResume(e -> {
            log.error("Error handling webhook: ", e);
            return Mono.just((Object)ResponseEntity.status((int)500).body((Object)"Internal Server Error"));
        });
    }

    private Mono<UserResponse> convertToUserResponse(Object userResponse) {
        try {
            String json = this.objectMapper.writeValueAsString(userResponse);
            System.err.println("json: 1" + json);
            UserResponse userBody = (UserResponse)this.objectMapper.readValue(json, UserResponse.class);
            return Mono.just((Object)userBody);
        }
        catch (Exception e) {
            log.error("Error converting user response: ", (Throwable)e);
            return Mono.error((Throwable)new RuntimeException("Invalid user response format"));
        }
    }

    private Mono<String> saveHistoryConversations(LhiaFlowRequest messageModel, String data) {
        System.out.println(messageModel);
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(messageModel.getConversationChatId(), messageModel.getChannel(), (String)(messageModel.getMessage() != null ? messageModel.getMessage() : "Archivo de tipo [" + messageModel.getType() + "]"), "USER", "ASESOR", messageModel.getNick());
        return this.historyConversationService.save(userHistoryConversation).thenReturn((Object)data);
    }

    public StateConversationService getStateConversationService() {
        return this.stateConversationService;
    }

    public Environment getEnv() {
        return this.env;
    }

    public ApiBotpressService getApiBotpressService() {
        return this.apiBotpressService;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ApiLhiaFLowService getApiLhiaFLowService() {
        return this.apiLhiaFLowService;
    }

    public ResponseUtil getResponseUtil() {
        return this.responseUtil;
    }

    public ApiLhiaService getApiLhiaService() {
        return this.apiLhiaService;
    }

    public LhiaProcessService getLhiaProcessService() {
        return this.lhiaProcessService;
    }

    public CampaignMessageDAO getCampaignMessageDAO() {
        return this.campaignMessageDAO;
    }

    public ApiWhatsAppService getWhatsAppService() {
        return this.whatsAppService;
    }

    public HistoryConversationItemService getHistoryConversationService() {
        return this.historyConversationService;
    }

    public ThinkAgentService getThinkAgentService() {
        return this.thinkAgentService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookController)) {
            return false;
        }
        WebhookController other = (WebhookController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        StateConversationService this$stateConversationService = this.getStateConversationService();
        StateConversationService other$stateConversationService = other.getStateConversationService();
        if (this$stateConversationService == null ? other$stateConversationService != null : !this$stateConversationService.equals(other$stateConversationService)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        ApiBotpressService this$apiBotpressService = this.getApiBotpressService();
        ApiBotpressService other$apiBotpressService = other.getApiBotpressService();
        if (this$apiBotpressService == null ? other$apiBotpressService != null : !this$apiBotpressService.equals(other$apiBotpressService)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        ApiLhiaFLowService this$apiLhiaFLowService = this.getApiLhiaFLowService();
        ApiLhiaFLowService other$apiLhiaFLowService = other.getApiLhiaFLowService();
        if (this$apiLhiaFLowService == null ? other$apiLhiaFLowService != null : !this$apiLhiaFLowService.equals(other$apiLhiaFLowService)) {
            return false;
        }
        ResponseUtil this$responseUtil = this.getResponseUtil();
        ResponseUtil other$responseUtil = other.getResponseUtil();
        if (this$responseUtil == null ? other$responseUtil != null : !this$responseUtil.equals(other$responseUtil)) {
            return false;
        }
        ApiLhiaService this$apiLhiaService = this.getApiLhiaService();
        ApiLhiaService other$apiLhiaService = other.getApiLhiaService();
        if (this$apiLhiaService == null ? other$apiLhiaService != null : !this$apiLhiaService.equals(other$apiLhiaService)) {
            return false;
        }
        LhiaProcessService this$lhiaProcessService = this.getLhiaProcessService();
        LhiaProcessService other$lhiaProcessService = other.getLhiaProcessService();
        if (this$lhiaProcessService == null ? other$lhiaProcessService != null : !this$lhiaProcessService.equals(other$lhiaProcessService)) {
            return false;
        }
        CampaignMessageDAO this$campaignMessageDAO = this.getCampaignMessageDAO();
        CampaignMessageDAO other$campaignMessageDAO = other.getCampaignMessageDAO();
        if (this$campaignMessageDAO == null ? other$campaignMessageDAO != null : !this$campaignMessageDAO.equals(other$campaignMessageDAO)) {
            return false;
        }
        ApiWhatsAppService this$whatsAppService = this.getWhatsAppService();
        ApiWhatsAppService other$whatsAppService = other.getWhatsAppService();
        if (this$whatsAppService == null ? other$whatsAppService != null : !this$whatsAppService.equals(other$whatsAppService)) {
            return false;
        }
        HistoryConversationItemService this$historyConversationService = this.getHistoryConversationService();
        HistoryConversationItemService other$historyConversationService = other.getHistoryConversationService();
        if (this$historyConversationService == null ? other$historyConversationService != null : !this$historyConversationService.equals(other$historyConversationService)) {
            return false;
        }
        ThinkAgentService this$thinkAgentService = this.getThinkAgentService();
        ThinkAgentService other$thinkAgentService = other.getThinkAgentService();
        return !(this$thinkAgentService == null ? other$thinkAgentService != null : !this$thinkAgentService.equals(other$thinkAgentService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StateConversationService $stateConversationService = this.getStateConversationService();
        result = result * 59 + ($stateConversationService == null ? 43 : $stateConversationService.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        ApiBotpressService $apiBotpressService = this.getApiBotpressService();
        result = result * 59 + ($apiBotpressService == null ? 43 : $apiBotpressService.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        ApiLhiaFLowService $apiLhiaFLowService = this.getApiLhiaFLowService();
        result = result * 59 + ($apiLhiaFLowService == null ? 43 : $apiLhiaFLowService.hashCode());
        ResponseUtil $responseUtil = this.getResponseUtil();
        result = result * 59 + ($responseUtil == null ? 43 : $responseUtil.hashCode());
        ApiLhiaService $apiLhiaService = this.getApiLhiaService();
        result = result * 59 + ($apiLhiaService == null ? 43 : $apiLhiaService.hashCode());
        LhiaProcessService $lhiaProcessService = this.getLhiaProcessService();
        result = result * 59 + ($lhiaProcessService == null ? 43 : $lhiaProcessService.hashCode());
        CampaignMessageDAO $campaignMessageDAO = this.getCampaignMessageDAO();
        result = result * 59 + ($campaignMessageDAO == null ? 43 : $campaignMessageDAO.hashCode());
        ApiWhatsAppService $whatsAppService = this.getWhatsAppService();
        result = result * 59 + ($whatsAppService == null ? 43 : $whatsAppService.hashCode());
        HistoryConversationItemService $historyConversationService = this.getHistoryConversationService();
        result = result * 59 + ($historyConversationService == null ? 43 : $historyConversationService.hashCode());
        ThinkAgentService $thinkAgentService = this.getThinkAgentService();
        result = result * 59 + ($thinkAgentService == null ? 43 : $thinkAgentService.hashCode());
        return result;
    }

    public String toString() {
        return "WebhookController(stateConversationService=" + this.getStateConversationService() + ", env=" + this.getEnv() + ", apiBotpressService=" + this.getApiBotpressService() + ", objectMapper=" + this.getObjectMapper() + ", apiLhiaFLowService=" + this.getApiLhiaFLowService() + ", responseUtil=" + this.getResponseUtil() + ", apiLhiaService=" + this.getApiLhiaService() + ", lhiaProcessService=" + this.getLhiaProcessService() + ", campaignMessageDAO=" + this.getCampaignMessageDAO() + ", whatsAppService=" + this.getWhatsAppService() + ", historyConversationService=" + this.getHistoryConversationService() + ", thinkAgentService=" + this.getThinkAgentService() + ")";
    }

    public WebhookController(StateConversationService stateConversationService, Environment env, ApiBotpressService apiBotpressService, ObjectMapper objectMapper, ApiLhiaFLowService apiLhiaFLowService, ResponseUtil responseUtil, ApiLhiaService apiLhiaService, LhiaProcessService lhiaProcessService, CampaignMessageDAO campaignMessageDAO, ApiWhatsAppService whatsAppService, HistoryConversationItemService historyConversationService, ThinkAgentService thinkAgentService) {
        this.stateConversationService = stateConversationService;
        this.env = env;
        this.apiBotpressService = apiBotpressService;
        this.objectMapper = objectMapper;
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.responseUtil = responseUtil;
        this.apiLhiaService = apiLhiaService;
        this.lhiaProcessService = lhiaProcessService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.whatsAppService = whatsAppService;
        this.historyConversationService = historyConversationService;
        this.thinkAgentService = thinkAgentService;
    }
}

