
CREATE SCHEMA IF NOT EXISTS facturacionperseo;

CREATE TABLE IF NOT EXISTS facturacionperseo.t_factura(
	id SERIAL primary key,
	
	establecimiento VARCHAR(10),
	punto_emision VARCHAR(10),
	secuencial VARCHAR(20),
	sri_documentos_codigo VARCHAR(20),
	forma_pago_empresa_id VARCHAR(20),
	forma_pago_sri_codigo VARCHAR(20),
	
	clientes_id INTEGER,
	clientes_sucursales_id INTEGER,
	secuencias_id INTEGER,
	cajas_id INTEGER,
	centros_costos_id INTEGER,
	almacenes_id INTEGER,
	facturadores_id INTEGER,
	vendedores_id INTEGER,
	tarifas_id INTEGER,
	
	emision DATE,
	vence DATE,
	fecha_creacion TIMESTAMP,
	usuario_creacion VARCHAR(100),
	
	dispositivo VARCHAR(50),
	uuid VARCHAR(100) unique NOT NULL,
	
	concepto text,
	observacion text,
	
	subtotal numeric(15,2),
	subtotal_sin_iva numeric(15,2),
	subtotal_con_iva numeric(15,2),
	total_descuento numeric(15,2),
	subtotal_neto numeric(15,2),
	total_ice numeric(15,2),
	total_iva numeric(15,2),
	total numeric(15,2),
	total_neto numeric(15,2)
);


CREATE TABLE IF NOT EXISTS facturacionperseo.t_factura_detalle (
    id SERIAL PRIMARY KEY,

    factura_id INTEGER NOT NULL,

    productos_id INTEGER,
    centros_costos_id INTEGER,
    almacenes_id INTEGER,
    medidas_id INTEGER,

    cantidad_digitada NUMERIC(15, 4),
    cantidad_factor INTEGER,
    cantidad NUMERIC(15, 4),

    ctrl_negativos BOOLEAN,
    precio NUMERIC(15, 4),
    precio_visible NUMERIC(15, 4),
    precio_iva NUMERIC(15, 4),
    descuento NUMERIC(15, 4),
    descuento_valor NUMERIC(15, 4),
    costo NUMERIC(15, 4),

    iva INTEGER,
    servicio BOOLEAN,

    informacion TEXT,
    informacion_detalle TEXT,

    CONSTRAINT fk_factura
        FOREIGN KEY (factura_id)
        REFERENCES facturacionperseo.t_factura(id)
        ON DELETE CASCADE
);

