/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.utils;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import java.util.stream.Collectors;

public class ValidationUtil {
    private static final ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    private static final Validator validator = factory.getValidator();

    private ValidationUtil() {
    }

    public static <T> void validateAndThrow(T object) {
        Set violaciones = validator.validate(object, new Class[0]);
        if (!violaciones.isEmpty()) {
            String errores = violaciones.stream().map(v -> v.getPropertyPath() + ": " + v.getMessage()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Errores de validaci\u00f3n -> " + errores);
        }
    }
}

