/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.strategy.comprobantes.factura;

import com.facturacion.auth.service.AutenticationService;
import com.facturacion.client.perseo.ApiFacturaClient;
import com.facturacion.config.properties.FacturacionProperties;
import com.facturacion.core.enums.DocumentosSriEnum;
import com.facturacion.core.mappers.perseo.facturacion.CalculosFacturaMapper;
import com.facturacion.core.mappers.perseo.facturacion.DetalleItemMapper;
import com.facturacion.core.repository.FacturaDetalleRepository;
import com.facturacion.core.repository.FacturaRepository;
import com.facturacion.core.service.ClienteService;
import com.facturacion.core.service.FormasPagoService;
import com.facturacion.core.service.SecuenciaService;
import com.facturacion.core.service.calculos.FacturaCalculatorService;
import com.facturacion.core.service.slack.NotificationService;
import com.facturacion.data.DTO.request.DetalleItemRequest;
import com.facturacion.data.DTO.request.FacturaRequestDto;
import com.facturacion.data.Perseo.clientes.Cliente;
import com.facturacion.data.Perseo.facturar.DetalleFacturaDto;
import com.facturacion.data.Perseo.facturar.FacturaDto;
import com.facturacion.data.Perseo.facturar.FacturaTotales;
import com.facturacion.data.Perseo.facturar.crear.FacturaData;
import com.facturacion.data.Perseo.formasPago.empresa.FormasPagoEmpresa;
import com.facturacion.data.Perseo.formasPago.sri.FormasPagoSri;
import com.facturacion.data.Perseo.secuencias.Secuencia;
import com.facturacion.exceptions.ApiException;
import com.facturacion.exceptions.CustomException;
import com.facturacion.strategy.ComprobanteStrategy;
import com.facturacion.utils.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import reactor.core.publisher.Mono;

@Component
public class FacturaStrategy
implements ComprobanteStrategy<FacturaRequestDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacturaStrategy.class);
    private final FacturacionProperties facturacionProperties;
    private final SecuenciaService secuenciaService;
    private final FormasPagoService formasPagoService;
    private final ClienteService clienteService;
    private final FacturaCalculatorService calculatorService;
    private final ApiFacturaClient apiFacturaClient;
    private final FacturaRepository facturaRepository;
    private final FacturaDetalleRepository facturaDetalleRepository;
    private final NotificationService notificationService;
    private final AutenticationService autenticationService;

    public String getCodigoDocumentoSri() {
        return DocumentosSriEnum.FACTURA.getCodigo();
    }

    public String tipoComprobante() {
        return DocumentosSriEnum.FACTURA.getDocumento();
    }

    @Validated
    public Mono<FacturaData> procesarComprobante(FacturaRequestDto requestDto) {
        Secuencia secuenciaModel = (Secuencia)this.secuenciaService.obtenerSecuenciaByPuntoEmision(requestDto.getPuntoEmision()).block();
        FormasPagoEmpresa formaPagoEmpresaModel = (FormasPagoEmpresa)this.formasPagoService.obtenerFormaPagoEmpresaPorId(requestDto.getFormaPagoEmpresaId()).block();
        FormasPagoSri formaPagoSriModel = (FormasPagoSri)this.formasPagoService.obtenerFormaPagoSriPorCodigo(requestDto.getCodigoFormaPagoSri()).block();
        Cliente clienteModel = (Cliente)this.clienteService.obtenerClientePorIdentificacion(requestDto.getIdentificacionCliente()).block();
        log.warn("Cliente encontrado {}", (Object)clienteModel);
        FacturaDto factura = new FacturaDto(this.autenticationService.getMyParameter("preferred_username"));
        factura.setClientesId(clienteModel.clientesId());
        factura.setDetalles(this.mapDetailsDto(requestDto.getDetalles()));
        FacturaTotales totales = this.calculatorService.calcularTotales(factura.getDetalles());
        new CalculosFacturaMapper().mapCalculosToFacturaDto(factura, totales);
        factura.cargarInformacionInicial(this.facturacionProperties);
        factura.cargarInformacionComercial(secuenciaModel.establecimiento(), secuenciaModel.puntoEmision(), StringUtils.padWithZeros((int)secuenciaModel.numeroActual(), (int)secuenciaModel.numeroDigitos()), this.getCodigoDocumentoSri(), formaPagoEmpresaModel.formaPagoEmpresaId(), formaPagoSriModel.formaPagoSriCodigo(), secuenciaModel.secuenciasId());
        factura.cargarInformacionContable();
        factura.crearConceptoDeLaFactura();
        log.info("factura: {}", (Object)factura);
        factura.setObservacion(requestDto.getObservacion());
        return this.apiFacturaClient.CrearFacturaApi(factura).flatMap(res -> {
            log.info("response bill {}", res);
            if (res == null || res.facturas() == null || res.facturas().isEmpty()) {
                Mono.error((Throwable)new CustomException("Ocurri\u00f3 un error al obtener la respuesta de la factura, no se encontr\u00f3 contenido.", HttpStatus.NOT_FOUND));
            }
            this.almacenarFacturaAceptada(factura);
            return Mono.just((Object)((FacturaData)res.facturas().get(0)));
        }).switchIfEmpty(Mono.error((Throwable)new CustomException("Ocurri\u00f3 un error al obtener la respuesta de la factura, no se encontr\u00f3 contenido.", HttpStatus.NOT_FOUND))).onErrorResume(ApiException.class, ex -> {
            JsonNode jsonNode;
            String value;
            Object body = ex.getError().getBody();
            if (body instanceof JsonNode && (value = (jsonNode = (JsonNode)body).at("/fault/faultstring").asText(null)) != null) {
                return Mono.error((Throwable)new CustomException("Usuario: " + factura.getUsuarioCreacion() + "\nError de interconexi\u00f3n con respuesta: " + value + " \n\n*Factura:*\n " + factura.getConcepto(), HttpStatus.BAD_REQUEST));
            }
            log.info("response en service {}", (Object)ex.getError());
            return Mono.error((Throwable)ex);
        });
    }

    private void almacenarFacturaAceptada(FacturaDto dto) {
        try {
            Long id = this.facturaRepository.insertarCabeceraYObtenerId(dto);
            if (id != null) {
                log.info("Insertando detalles en la factura con id: {}", (Object)id);
                this.facturaDetalleRepository.insertarDetalles(dto.getDetalles(), id);
            } else {
                log.error("No se encontr\u00f3 el identificador de la factura almacenada");
            }
        }
        catch (Exception e) {
            log.error("Ocurrio un error al almacenar la factura o su detalle", (Throwable)e);
            this.notificationService.enviarNotificacionError("ERROR AL GUARDAR LA FACTURA", e.getMessage());
        }
    }

    private List<DetalleFacturaDto> mapDetailsDto(List<DetalleItemRequest> detalles) {
        ArrayList<DetalleFacturaDto> detailsDto = new ArrayList<DetalleFacturaDto>();
        for (DetalleItemRequest detalleItemRequest : detalles) {
            detailsDto.add(new DetalleItemMapper().mapToDetalleFactura(detalleItemRequest, this.facturacionProperties));
        }
        return detailsDto;
    }

    @Generated
    public FacturaStrategy(FacturacionProperties facturacionProperties, SecuenciaService secuenciaService, FormasPagoService formasPagoService, ClienteService clienteService, FacturaCalculatorService calculatorService, ApiFacturaClient apiFacturaClient, FacturaRepository facturaRepository, FacturaDetalleRepository facturaDetalleRepository, NotificationService notificationService, AutenticationService autenticationService) {
        this.facturacionProperties = facturacionProperties;
        this.secuenciaService = secuenciaService;
        this.formasPagoService = formasPagoService;
        this.clienteService = clienteService;
        this.calculatorService = calculatorService;
        this.apiFacturaClient = apiFacturaClient;
        this.facturaRepository = facturaRepository;
        this.facturaDetalleRepository = facturaDetalleRepository;
        this.notificationService = notificationService;
        this.autenticationService = autenticationService;
    }
}

