/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.strategy.comprobantes;

import com.facturacion.exceptions.CustomException;
import com.facturacion.strategy.ComprobanteStrategy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class ComprobanteStrategyFactory {
    private final Map<String, ComprobanteStrategy<?>> estrategias;

    public ComprobanteStrategyFactory(List<ComprobanteStrategy<?>> listaEstrategias) {
        this.estrategias = listaEstrategias.stream().collect(Collectors.toMap(estrategia -> estrategia.tipoComprobante().toUpperCase(), estrategia -> estrategia));
    }

    public ComprobanteStrategy<?> getStrategy(String tipo) {
        ComprobanteStrategy strategy = (ComprobanteStrategy)this.estrategias.get(tipo.toUpperCase());
        if (strategy == null) {
            throw new CustomException("Tipo de comprobante no soportado: " + tipo, HttpStatus.BAD_REQUEST);
        }
        return strategy;
    }
}

