/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.interceptors;

import com.facturacion.auth.service.AutenticationService;
import com.facturacion.client.ErrorResponse;
import com.facturacion.core.service.slack.NotificationService;
import com.facturacion.exceptions.ApiException;
import com.facturacion.exceptions.CustomException;
import com.facturacion.utils.ApiResponse;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.servlet.NoHandlerFoundException;

@Hidden
@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final NotificationService notificationService;
    private final AutenticationService autenticationService;

    @ExceptionHandler(value={CustomException.class})
    public ResponseEntity<ApiResponse<Object>> handleCustomException(CustomException ex, WebRequest request) {
        ApiResponse response = ApiResponse.error((int)ex.getHttpStatus().value(), (String)ex.getMessage());
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de CustomException", ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)ex.getHttpStatus()).body((Object)response);
    }

    @ExceptionHandler(value={ApiException.class})
    public ResponseEntity<ApiResponse<?>> handleApiException(ApiException ex) {
        ErrorResponse error = ex.getError();
        HttpStatus status = HttpStatus.resolve((int)error.getStatus());
        if (status == null) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        ApiResponse apiResponse = ApiResponse.error((int)status.value(), (String)("Usuario: " + userSession + "\nError en interconexi\u00f3n interna"));
        this.notificationService.enviarNotificacionError("Error de ApiException", ex.getError().getBody().toString());
        return ResponseEntity.status((HttpStatusCode)status).body((Object)apiResponse);
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public ResponseEntity<ApiResponse<Object>> handleAsyncRequestTimeoutException() {
        ApiResponse response = ApiResponse.error((int)HttpStatus.REQUEST_TIMEOUT.value(), (String)"La solicitud ha tardado demasiado tiempo en procesarse.");
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de AsyncRequestTimeoutException", response.getMessage());
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ApiResponse<Object>> handleNoResourceFoundException(NoHandlerFoundException ex, WebRequest request) {
        log.error("Ruta no encontrada:", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.NOT_FOUND.value(), (String)"La ruta solicitada no existe");
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de NoHandlerFoundException", response.getMessage());
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ApiResponse<Object>> handleNoMessageReadeableException(HttpMessageNotReadableException ex, WebRequest request) {
        log.error("Ruta no encontrada:", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.NOT_ACCEPTABLE.value(), (String)"Revisar los par\u00e1metros requeridos en esta petici\u00f3n");
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de HttpMessageNotReadableException", response.getMessage());
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<ApiResponse<Object>> handleMethodNotSupportedException(HttpRequestMethodNotSupportedException ex, WebRequest request) {
        log.error("Metodo no soportado", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.NOT_ACCEPTABLE.value(), (String)"El m\u00e9todo de la petici\u00f3n no es correcta");
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de HttpRequestMethodNotSupportedException", response.getMessage());
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiResponse<Object>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        log.warn("Exception por validacion de campos {}", (Throwable)ex);
        HashMap errors = new HashMap();
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        ApiResponse response = ApiResponse.errorFields((int)HttpStatus.NOT_ACCEPTABLE.value(), errors);
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de MethodArgumentNotValidException", response.getMessage() + "\n*Campos:*\n\n" + response.getErrorsFields());
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(Exception ex, WebRequest request) {
        log.error("Excepci\u00f3n no controlada:", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        String userSession = this.autenticationService.getMyParameter("preferred_username");
        this.notificationService.enviarNotificacionError("Usuario: " + userSession + "\nError de Exception", response.getMessage());
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @Generated
    public GlobalExceptionHandler(NotificationService notificationService, AutenticationService autenticationService) {
        this.notificationService = notificationService;
        this.autenticationService = autenticationService;
    }
}

