/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.data.Perseo.facturar;

import com.facturacion.config.properties.FacturacionProperties;
import com.facturacion.data.Perseo.facturar.DetalleFacturaDto;
import com.facturacion.data.Perseo.facturar.MovimientoFacturaDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class FacturaDto {
    @JsonProperty(value="establecimiento")
    private String establecimiento;
    @JsonProperty(value="puntoemision")
    private String puntoEmision;
    @JsonProperty(value="secuencial")
    private String secuencial;
    @JsonProperty(value="sri_documentoscodigo")
    private String sriDocumentosCodigo;
    @JsonProperty(value="forma_pago_empresaid")
    private String formaPagoEmpresaId;
    @JsonProperty(value="forma_pago_sri_codigo")
    private String formaPagoSriCodigo;
    @JsonProperty(value="clientesid")
    private Integer clientesId;
    @JsonProperty(value="clientes_sucursalesid")
    private Integer clientesSucursalesId;
    @JsonProperty(value="secuenciasid")
    private Integer secuenciasId;
    @JsonProperty(value="cajasid")
    private Integer cajasId;
    @JsonProperty(value="centros_costosid")
    private Integer centrosCostosId;
    @JsonProperty(value="almacenesid")
    private Integer almacenesId;
    @JsonProperty(value="facturadoresid")
    private Integer facturadoresId;
    @JsonProperty(value="vendedoresid")
    private Integer vendedoresId;
    @JsonProperty(value="tarifasid")
    private Integer tarifasId;
    @JsonProperty(value="emision")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private LocalDate emision;
    @JsonProperty(value="vence")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private LocalDate vence;
    @JsonProperty(value="fechacreacion")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMddHHmmss")
    private LocalDateTime fechaCreacion;
    @JsonProperty(value="usuariocreacion")
    private String usuarioCreacion;
    @JsonProperty(value="dispositivo")
    private String dispositivo;
    @JsonProperty(value="uui")
    private String uuid;
    @JsonProperty(value="concepto")
    private String concepto;
    @JsonProperty(value="observacion")
    private String observacion;
    @JsonProperty(value="subtotal")
    private BigDecimal subtotal;
    @JsonProperty(value="subtotalsiniva")
    private BigDecimal subtotalSinIva;
    @JsonProperty(value="subtotalconiva")
    private BigDecimal subtotalConIva;
    @JsonProperty(value="total_descuento")
    private BigDecimal totalDescuento;
    @JsonProperty(value="subtotalneto")
    private BigDecimal subtotalNeto;
    @JsonProperty(value="total_ice")
    private BigDecimal totalIce;
    @JsonProperty(value="total_iva")
    private BigDecimal totalIva;
    @JsonProperty(value="total")
    private BigDecimal total;
    @JsonProperty(value="totalneto")
    private BigDecimal totalNeto;
    @JsonProperty(value="empresaid")
    private Integer empresaId;
    @JsonProperty(value="usuarioid")
    private Integer usuarioId;
    private List<DetalleFacturaDto> detalles;
    private MovimientoFacturaDto movimiento;

    public FacturaDto(String usuarioSession) {
        this.usuarioCreacion = usuarioSession;
    }

    public void cargarInformacionInicial(FacturacionProperties props) {
        this.fechaCreacion = LocalDateTime.now();
        this.emision = LocalDate.now();
        this.vence = this.emision.plusDays(30L);
        this.dispositivo = props.getDispositivo();
        this.uuid = UUID.randomUUID().toString();
        this.cajasId = props.getCajasId();
        this.centrosCostosId = props.getCentroCostosId();
        this.almacenesId = props.getAlmacenesId();
        this.facturadoresId = props.getFacturadoresId();
        this.vendedoresId = props.getVendedoresId();
    }

    public void cargarInformacionComercial(String establecimiento, String puntoEmision, String secuencia, String sriDocumentosCodigo, String formaPagoEmpresaId, String formaPagoSriCodigo, Integer secuenciaId) {
        this.establecimiento = establecimiento;
        this.puntoEmision = puntoEmision;
        this.secuencial = secuencia;
        this.sriDocumentosCodigo = sriDocumentosCodigo;
        this.formaPagoEmpresaId = formaPagoEmpresaId;
        this.formaPagoSriCodigo = formaPagoSriCodigo;
        this.secuenciasId = secuenciaId;
    }

    public void cargarInformacionContable() {
        this.movimiento = new MovimientoFacturaDto();
        this.movimiento.setFormaPagoEmpresaid(this.formaPagoEmpresaId);
        this.movimiento.setFormaPagoSri(this.formaPagoSriCodigo);
        this.movimiento.setCajasId(this.cajasId);
        this.movimiento.setDocumentoOrigen(this.secuencial);
        this.movimiento.setImporte(this.total);
        this.movimiento.setFechaMovimiento(LocalDate.now());
        this.movimiento.setFechaVence(this.movimiento.getFechaMovimiento().plusDays(30L));
    }

    public void crearConceptoDeLaFactura() {
        this.concepto = "Venta: " + this.establecimiento + "-" + this.puntoEmision + "-" + this.secuencial + " Con el total de: " + this.total;
    }

    @Generated
    public String getEstablecimiento() {
        return this.establecimiento;
    }

    @Generated
    public String getPuntoEmision() {
        return this.puntoEmision;
    }

    @Generated
    public String getSecuencial() {
        return this.secuencial;
    }

    @Generated
    public String getSriDocumentosCodigo() {
        return this.sriDocumentosCodigo;
    }

    @Generated
    public String getFormaPagoEmpresaId() {
        return this.formaPagoEmpresaId;
    }

    @Generated
    public String getFormaPagoSriCodigo() {
        return this.formaPagoSriCodigo;
    }

    @Generated
    public Integer getClientesId() {
        return this.clientesId;
    }

    @Generated
    public Integer getClientesSucursalesId() {
        return this.clientesSucursalesId;
    }

    @Generated
    public Integer getSecuenciasId() {
        return this.secuenciasId;
    }

    @Generated
    public Integer getCajasId() {
        return this.cajasId;
    }

    @Generated
    public Integer getCentrosCostosId() {
        return this.centrosCostosId;
    }

    @Generated
    public Integer getAlmacenesId() {
        return this.almacenesId;
    }

    @Generated
    public Integer getFacturadoresId() {
        return this.facturadoresId;
    }

    @Generated
    public Integer getVendedoresId() {
        return this.vendedoresId;
    }

    @Generated
    public Integer getTarifasId() {
        return this.tarifasId;
    }

    @Generated
    public LocalDate getEmision() {
        return this.emision;
    }

    @Generated
    public LocalDate getVence() {
        return this.vence;
    }

    @Generated
    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    @Generated
    public String getUsuarioCreacion() {
        return this.usuarioCreacion;
    }

    @Generated
    public String getDispositivo() {
        return this.dispositivo;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getConcepto() {
        return this.concepto;
    }

    @Generated
    public String getObservacion() {
        return this.observacion;
    }

    @Generated
    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    @Generated
    public BigDecimal getSubtotalSinIva() {
        return this.subtotalSinIva;
    }

    @Generated
    public BigDecimal getSubtotalConIva() {
        return this.subtotalConIva;
    }

    @Generated
    public BigDecimal getTotalDescuento() {
        return this.totalDescuento;
    }

    @Generated
    public BigDecimal getSubtotalNeto() {
        return this.subtotalNeto;
    }

    @Generated
    public BigDecimal getTotalIce() {
        return this.totalIce;
    }

    @Generated
    public BigDecimal getTotalIva() {
        return this.totalIva;
    }

    @Generated
    public BigDecimal getTotal() {
        return this.total;
    }

    @Generated
    public BigDecimal getTotalNeto() {
        return this.totalNeto;
    }

    @Generated
    public Integer getEmpresaId() {
        return this.empresaId;
    }

    @Generated
    public Integer getUsuarioId() {
        return this.usuarioId;
    }

    @Generated
    public List<DetalleFacturaDto> getDetalles() {
        return this.detalles;
    }

    @Generated
    public MovimientoFacturaDto getMovimiento() {
        return this.movimiento;
    }

    @JsonProperty(value="establecimiento")
    @Generated
    public void setEstablecimiento(String establecimiento) {
        this.establecimiento = establecimiento;
    }

    @JsonProperty(value="puntoemision")
    @Generated
    public void setPuntoEmision(String puntoEmision) {
        this.puntoEmision = puntoEmision;
    }

    @JsonProperty(value="secuencial")
    @Generated
    public void setSecuencial(String secuencial) {
        this.secuencial = secuencial;
    }

    @JsonProperty(value="sri_documentoscodigo")
    @Generated
    public void setSriDocumentosCodigo(String sriDocumentosCodigo) {
        this.sriDocumentosCodigo = sriDocumentosCodigo;
    }

    @JsonProperty(value="forma_pago_empresaid")
    @Generated
    public void setFormaPagoEmpresaId(String formaPagoEmpresaId) {
        this.formaPagoEmpresaId = formaPagoEmpresaId;
    }

    @JsonProperty(value="forma_pago_sri_codigo")
    @Generated
    public void setFormaPagoSriCodigo(String formaPagoSriCodigo) {
        this.formaPagoSriCodigo = formaPagoSriCodigo;
    }

    @JsonProperty(value="clientesid")
    @Generated
    public void setClientesId(Integer clientesId) {
        this.clientesId = clientesId;
    }

    @JsonProperty(value="clientes_sucursalesid")
    @Generated
    public void setClientesSucursalesId(Integer clientesSucursalesId) {
        this.clientesSucursalesId = clientesSucursalesId;
    }

    @JsonProperty(value="secuenciasid")
    @Generated
    public void setSecuenciasId(Integer secuenciasId) {
        this.secuenciasId = secuenciasId;
    }

    @JsonProperty(value="cajasid")
    @Generated
    public void setCajasId(Integer cajasId) {
        this.cajasId = cajasId;
    }

    @JsonProperty(value="centros_costosid")
    @Generated
    public void setCentrosCostosId(Integer centrosCostosId) {
        this.centrosCostosId = centrosCostosId;
    }

    @JsonProperty(value="almacenesid")
    @Generated
    public void setAlmacenesId(Integer almacenesId) {
        this.almacenesId = almacenesId;
    }

    @JsonProperty(value="facturadoresid")
    @Generated
    public void setFacturadoresId(Integer facturadoresId) {
        this.facturadoresId = facturadoresId;
    }

    @JsonProperty(value="vendedoresid")
    @Generated
    public void setVendedoresId(Integer vendedoresId) {
        this.vendedoresId = vendedoresId;
    }

    @JsonProperty(value="tarifasid")
    @Generated
    public void setTarifasId(Integer tarifasId) {
        this.tarifasId = tarifasId;
    }

    @JsonProperty(value="emision")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    @Generated
    public void setEmision(LocalDate emision) {
        this.emision = emision;
    }

    @JsonProperty(value="vence")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    @Generated
    public void setVence(LocalDate vence) {
        this.vence = vence;
    }

    @JsonProperty(value="fechacreacion")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMddHHmmss")
    @Generated
    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @JsonProperty(value="usuariocreacion")
    @Generated
    public void setUsuarioCreacion(String usuarioCreacion) {
        this.usuarioCreacion = usuarioCreacion;
    }

    @JsonProperty(value="dispositivo")
    @Generated
    public void setDispositivo(String dispositivo) {
        this.dispositivo = dispositivo;
    }

    @JsonProperty(value="uui")
    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonProperty(value="concepto")
    @Generated
    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    @JsonProperty(value="observacion")
    @Generated
    public void setObservacion(String observacion) {
        this.observacion = observacion;
    }

    @JsonProperty(value="subtotal")
    @Generated
    public void setSubtotal(BigDecimal subtotal) {
        this.subtotal = subtotal;
    }

    @JsonProperty(value="subtotalsiniva")
    @Generated
    public void setSubtotalSinIva(BigDecimal subtotalSinIva) {
        this.subtotalSinIva = subtotalSinIva;
    }

    @JsonProperty(value="subtotalconiva")
    @Generated
    public void setSubtotalConIva(BigDecimal subtotalConIva) {
        this.subtotalConIva = subtotalConIva;
    }

    @JsonProperty(value="total_descuento")
    @Generated
    public void setTotalDescuento(BigDecimal totalDescuento) {
        this.totalDescuento = totalDescuento;
    }

    @JsonProperty(value="subtotalneto")
    @Generated
    public void setSubtotalNeto(BigDecimal subtotalNeto) {
        this.subtotalNeto = subtotalNeto;
    }

    @JsonProperty(value="total_ice")
    @Generated
    public void setTotalIce(BigDecimal totalIce) {
        this.totalIce = totalIce;
    }

    @JsonProperty(value="total_iva")
    @Generated
    public void setTotalIva(BigDecimal totalIva) {
        this.totalIva = totalIva;
    }

    @JsonProperty(value="total")
    @Generated
    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    @JsonProperty(value="totalneto")
    @Generated
    public void setTotalNeto(BigDecimal totalNeto) {
        this.totalNeto = totalNeto;
    }

    @JsonProperty(value="empresaid")
    @Generated
    public void setEmpresaId(Integer empresaId) {
        this.empresaId = empresaId;
    }

    @JsonProperty(value="usuarioid")
    @Generated
    public void setUsuarioId(Integer usuarioId) {
        this.usuarioId = usuarioId;
    }

    @Generated
    public void setDetalles(List<DetalleFacturaDto> detalles) {
        this.detalles = detalles;
    }

    @Generated
    public void setMovimiento(MovimientoFacturaDto movimiento) {
        this.movimiento = movimiento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacturaDto)) {
            return false;
        }
        FacturaDto other = (FacturaDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$clientesId = this.getClientesId();
        Integer other$clientesId = other.getClientesId();
        if (this$clientesId == null ? other$clientesId != null : !((Object)this$clientesId).equals(other$clientesId)) {
            return false;
        }
        Integer this$clientesSucursalesId = this.getClientesSucursalesId();
        Integer other$clientesSucursalesId = other.getClientesSucursalesId();
        if (this$clientesSucursalesId == null ? other$clientesSucursalesId != null : !((Object)this$clientesSucursalesId).equals(other$clientesSucursalesId)) {
            return false;
        }
        Integer this$secuenciasId = this.getSecuenciasId();
        Integer other$secuenciasId = other.getSecuenciasId();
        if (this$secuenciasId == null ? other$secuenciasId != null : !((Object)this$secuenciasId).equals(other$secuenciasId)) {
            return false;
        }
        Integer this$cajasId = this.getCajasId();
        Integer other$cajasId = other.getCajasId();
        if (this$cajasId == null ? other$cajasId != null : !((Object)this$cajasId).equals(other$cajasId)) {
            return false;
        }
        Integer this$centrosCostosId = this.getCentrosCostosId();
        Integer other$centrosCostosId = other.getCentrosCostosId();
        if (this$centrosCostosId == null ? other$centrosCostosId != null : !((Object)this$centrosCostosId).equals(other$centrosCostosId)) {
            return false;
        }
        Integer this$almacenesId = this.getAlmacenesId();
        Integer other$almacenesId = other.getAlmacenesId();
        if (this$almacenesId == null ? other$almacenesId != null : !((Object)this$almacenesId).equals(other$almacenesId)) {
            return false;
        }
        Integer this$facturadoresId = this.getFacturadoresId();
        Integer other$facturadoresId = other.getFacturadoresId();
        if (this$facturadoresId == null ? other$facturadoresId != null : !((Object)this$facturadoresId).equals(other$facturadoresId)) {
            return false;
        }
        Integer this$vendedoresId = this.getVendedoresId();
        Integer other$vendedoresId = other.getVendedoresId();
        if (this$vendedoresId == null ? other$vendedoresId != null : !((Object)this$vendedoresId).equals(other$vendedoresId)) {
            return false;
        }
        Integer this$tarifasId = this.getTarifasId();
        Integer other$tarifasId = other.getTarifasId();
        if (this$tarifasId == null ? other$tarifasId != null : !((Object)this$tarifasId).equals(other$tarifasId)) {
            return false;
        }
        Integer this$empresaId = this.getEmpresaId();
        Integer other$empresaId = other.getEmpresaId();
        if (this$empresaId == null ? other$empresaId != null : !((Object)this$empresaId).equals(other$empresaId)) {
            return false;
        }
        Integer this$usuarioId = this.getUsuarioId();
        Integer other$usuarioId = other.getUsuarioId();
        if (this$usuarioId == null ? other$usuarioId != null : !((Object)this$usuarioId).equals(other$usuarioId)) {
            return false;
        }
        String this$establecimiento = this.getEstablecimiento();
        String other$establecimiento = other.getEstablecimiento();
        if (this$establecimiento == null ? other$establecimiento != null : !this$establecimiento.equals(other$establecimiento)) {
            return false;
        }
        String this$puntoEmision = this.getPuntoEmision();
        String other$puntoEmision = other.getPuntoEmision();
        if (this$puntoEmision == null ? other$puntoEmision != null : !this$puntoEmision.equals(other$puntoEmision)) {
            return false;
        }
        String this$secuencial = this.getSecuencial();
        String other$secuencial = other.getSecuencial();
        if (this$secuencial == null ? other$secuencial != null : !this$secuencial.equals(other$secuencial)) {
            return false;
        }
        String this$sriDocumentosCodigo = this.getSriDocumentosCodigo();
        String other$sriDocumentosCodigo = other.getSriDocumentosCodigo();
        if (this$sriDocumentosCodigo == null ? other$sriDocumentosCodigo != null : !this$sriDocumentosCodigo.equals(other$sriDocumentosCodigo)) {
            return false;
        }
        String this$formaPagoEmpresaId = this.getFormaPagoEmpresaId();
        String other$formaPagoEmpresaId = other.getFormaPagoEmpresaId();
        if (this$formaPagoEmpresaId == null ? other$formaPagoEmpresaId != null : !this$formaPagoEmpresaId.equals(other$formaPagoEmpresaId)) {
            return false;
        }
        String this$formaPagoSriCodigo = this.getFormaPagoSriCodigo();
        String other$formaPagoSriCodigo = other.getFormaPagoSriCodigo();
        if (this$formaPagoSriCodigo == null ? other$formaPagoSriCodigo != null : !this$formaPagoSriCodigo.equals(other$formaPagoSriCodigo)) {
            return false;
        }
        LocalDate this$emision = this.getEmision();
        LocalDate other$emision = other.getEmision();
        if (this$emision == null ? other$emision != null : !((Object)this$emision).equals(other$emision)) {
            return false;
        }
        LocalDate this$vence = this.getVence();
        LocalDate other$vence = other.getVence();
        if (this$vence == null ? other$vence != null : !((Object)this$vence).equals(other$vence)) {
            return false;
        }
        LocalDateTime this$fechaCreacion = this.getFechaCreacion();
        LocalDateTime other$fechaCreacion = other.getFechaCreacion();
        if (this$fechaCreacion == null ? other$fechaCreacion != null : !((Object)this$fechaCreacion).equals(other$fechaCreacion)) {
            return false;
        }
        String this$usuarioCreacion = this.getUsuarioCreacion();
        String other$usuarioCreacion = other.getUsuarioCreacion();
        if (this$usuarioCreacion == null ? other$usuarioCreacion != null : !this$usuarioCreacion.equals(other$usuarioCreacion)) {
            return false;
        }
        String this$dispositivo = this.getDispositivo();
        String other$dispositivo = other.getDispositivo();
        if (this$dispositivo == null ? other$dispositivo != null : !this$dispositivo.equals(other$dispositivo)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$concepto = this.getConcepto();
        String other$concepto = other.getConcepto();
        if (this$concepto == null ? other$concepto != null : !this$concepto.equals(other$concepto)) {
            return false;
        }
        String this$observacion = this.getObservacion();
        String other$observacion = other.getObservacion();
        if (this$observacion == null ? other$observacion != null : !this$observacion.equals(other$observacion)) {
            return false;
        }
        BigDecimal this$subtotal = this.getSubtotal();
        BigDecimal other$subtotal = other.getSubtotal();
        if (this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal)) {
            return false;
        }
        BigDecimal this$subtotalSinIva = this.getSubtotalSinIva();
        BigDecimal other$subtotalSinIva = other.getSubtotalSinIva();
        if (this$subtotalSinIva == null ? other$subtotalSinIva != null : !((Object)this$subtotalSinIva).equals(other$subtotalSinIva)) {
            return false;
        }
        BigDecimal this$subtotalConIva = this.getSubtotalConIva();
        BigDecimal other$subtotalConIva = other.getSubtotalConIva();
        if (this$subtotalConIva == null ? other$subtotalConIva != null : !((Object)this$subtotalConIva).equals(other$subtotalConIva)) {
            return false;
        }
        BigDecimal this$totalDescuento = this.getTotalDescuento();
        BigDecimal other$totalDescuento = other.getTotalDescuento();
        if (this$totalDescuento == null ? other$totalDescuento != null : !((Object)this$totalDescuento).equals(other$totalDescuento)) {
            return false;
        }
        BigDecimal this$subtotalNeto = this.getSubtotalNeto();
        BigDecimal other$subtotalNeto = other.getSubtotalNeto();
        if (this$subtotalNeto == null ? other$subtotalNeto != null : !((Object)this$subtotalNeto).equals(other$subtotalNeto)) {
            return false;
        }
        BigDecimal this$totalIce = this.getTotalIce();
        BigDecimal other$totalIce = other.getTotalIce();
        if (this$totalIce == null ? other$totalIce != null : !((Object)this$totalIce).equals(other$totalIce)) {
            return false;
        }
        BigDecimal this$totalIva = this.getTotalIva();
        BigDecimal other$totalIva = other.getTotalIva();
        if (this$totalIva == null ? other$totalIva != null : !((Object)this$totalIva).equals(other$totalIva)) {
            return false;
        }
        BigDecimal this$total = this.getTotal();
        BigDecimal other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        BigDecimal this$totalNeto = this.getTotalNeto();
        BigDecimal other$totalNeto = other.getTotalNeto();
        if (this$totalNeto == null ? other$totalNeto != null : !((Object)this$totalNeto).equals(other$totalNeto)) {
            return false;
        }
        List this$detalles = this.getDetalles();
        List other$detalles = other.getDetalles();
        if (this$detalles == null ? other$detalles != null : !((Object)this$detalles).equals(other$detalles)) {
            return false;
        }
        MovimientoFacturaDto this$movimiento = this.getMovimiento();
        MovimientoFacturaDto other$movimiento = other.getMovimiento();
        return !(this$movimiento == null ? other$movimiento != null : !this$movimiento.equals(other$movimiento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FacturaDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $clientesId = this.getClientesId();
        result = result * 59 + ($clientesId == null ? 43 : ((Object)$clientesId).hashCode());
        Integer $clientesSucursalesId = this.getClientesSucursalesId();
        result = result * 59 + ($clientesSucursalesId == null ? 43 : ((Object)$clientesSucursalesId).hashCode());
        Integer $secuenciasId = this.getSecuenciasId();
        result = result * 59 + ($secuenciasId == null ? 43 : ((Object)$secuenciasId).hashCode());
        Integer $cajasId = this.getCajasId();
        result = result * 59 + ($cajasId == null ? 43 : ((Object)$cajasId).hashCode());
        Integer $centrosCostosId = this.getCentrosCostosId();
        result = result * 59 + ($centrosCostosId == null ? 43 : ((Object)$centrosCostosId).hashCode());
        Integer $almacenesId = this.getAlmacenesId();
        result = result * 59 + ($almacenesId == null ? 43 : ((Object)$almacenesId).hashCode());
        Integer $facturadoresId = this.getFacturadoresId();
        result = result * 59 + ($facturadoresId == null ? 43 : ((Object)$facturadoresId).hashCode());
        Integer $vendedoresId = this.getVendedoresId();
        result = result * 59 + ($vendedoresId == null ? 43 : ((Object)$vendedoresId).hashCode());
        Integer $tarifasId = this.getTarifasId();
        result = result * 59 + ($tarifasId == null ? 43 : ((Object)$tarifasId).hashCode());
        Integer $empresaId = this.getEmpresaId();
        result = result * 59 + ($empresaId == null ? 43 : ((Object)$empresaId).hashCode());
        Integer $usuarioId = this.getUsuarioId();
        result = result * 59 + ($usuarioId == null ? 43 : ((Object)$usuarioId).hashCode());
        String $establecimiento = this.getEstablecimiento();
        result = result * 59 + ($establecimiento == null ? 43 : $establecimiento.hashCode());
        String $puntoEmision = this.getPuntoEmision();
        result = result * 59 + ($puntoEmision == null ? 43 : $puntoEmision.hashCode());
        String $secuencial = this.getSecuencial();
        result = result * 59 + ($secuencial == null ? 43 : $secuencial.hashCode());
        String $sriDocumentosCodigo = this.getSriDocumentosCodigo();
        result = result * 59 + ($sriDocumentosCodigo == null ? 43 : $sriDocumentosCodigo.hashCode());
        String $formaPagoEmpresaId = this.getFormaPagoEmpresaId();
        result = result * 59 + ($formaPagoEmpresaId == null ? 43 : $formaPagoEmpresaId.hashCode());
        String $formaPagoSriCodigo = this.getFormaPagoSriCodigo();
        result = result * 59 + ($formaPagoSriCodigo == null ? 43 : $formaPagoSriCodigo.hashCode());
        LocalDate $emision = this.getEmision();
        result = result * 59 + ($emision == null ? 43 : ((Object)$emision).hashCode());
        LocalDate $vence = this.getVence();
        result = result * 59 + ($vence == null ? 43 : ((Object)$vence).hashCode());
        LocalDateTime $fechaCreacion = this.getFechaCreacion();
        result = result * 59 + ($fechaCreacion == null ? 43 : ((Object)$fechaCreacion).hashCode());
        String $usuarioCreacion = this.getUsuarioCreacion();
        result = result * 59 + ($usuarioCreacion == null ? 43 : $usuarioCreacion.hashCode());
        String $dispositivo = this.getDispositivo();
        result = result * 59 + ($dispositivo == null ? 43 : $dispositivo.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $concepto = this.getConcepto();
        result = result * 59 + ($concepto == null ? 43 : $concepto.hashCode());
        String $observacion = this.getObservacion();
        result = result * 59 + ($observacion == null ? 43 : $observacion.hashCode());
        BigDecimal $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        BigDecimal $subtotalSinIva = this.getSubtotalSinIva();
        result = result * 59 + ($subtotalSinIva == null ? 43 : ((Object)$subtotalSinIva).hashCode());
        BigDecimal $subtotalConIva = this.getSubtotalConIva();
        result = result * 59 + ($subtotalConIva == null ? 43 : ((Object)$subtotalConIva).hashCode());
        BigDecimal $totalDescuento = this.getTotalDescuento();
        result = result * 59 + ($totalDescuento == null ? 43 : ((Object)$totalDescuento).hashCode());
        BigDecimal $subtotalNeto = this.getSubtotalNeto();
        result = result * 59 + ($subtotalNeto == null ? 43 : ((Object)$subtotalNeto).hashCode());
        BigDecimal $totalIce = this.getTotalIce();
        result = result * 59 + ($totalIce == null ? 43 : ((Object)$totalIce).hashCode());
        BigDecimal $totalIva = this.getTotalIva();
        result = result * 59 + ($totalIva == null ? 43 : ((Object)$totalIva).hashCode());
        BigDecimal $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        BigDecimal $totalNeto = this.getTotalNeto();
        result = result * 59 + ($totalNeto == null ? 43 : ((Object)$totalNeto).hashCode());
        List $detalles = this.getDetalles();
        result = result * 59 + ($detalles == null ? 43 : ((Object)$detalles).hashCode());
        MovimientoFacturaDto $movimiento = this.getMovimiento();
        result = result * 59 + ($movimiento == null ? 43 : $movimiento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FacturaDto(establecimiento=" + this.getEstablecimiento() + ", puntoEmision=" + this.getPuntoEmision() + ", secuencial=" + this.getSecuencial() + ", sriDocumentosCodigo=" + this.getSriDocumentosCodigo() + ", formaPagoEmpresaId=" + this.getFormaPagoEmpresaId() + ", formaPagoSriCodigo=" + this.getFormaPagoSriCodigo() + ", clientesId=" + this.getClientesId() + ", clientesSucursalesId=" + this.getClientesSucursalesId() + ", secuenciasId=" + this.getSecuenciasId() + ", cajasId=" + this.getCajasId() + ", centrosCostosId=" + this.getCentrosCostosId() + ", almacenesId=" + this.getAlmacenesId() + ", facturadoresId=" + this.getFacturadoresId() + ", vendedoresId=" + this.getVendedoresId() + ", tarifasId=" + this.getTarifasId() + ", emision=" + this.getEmision() + ", vence=" + this.getVence() + ", fechaCreacion=" + this.getFechaCreacion() + ", usuarioCreacion=" + this.getUsuarioCreacion() + ", dispositivo=" + this.getDispositivo() + ", uuid=" + this.getUuid() + ", concepto=" + this.getConcepto() + ", observacion=" + this.getObservacion() + ", subtotal=" + this.getSubtotal() + ", subtotalSinIva=" + this.getSubtotalSinIva() + ", subtotalConIva=" + this.getSubtotalConIva() + ", totalDescuento=" + this.getTotalDescuento() + ", subtotalNeto=" + this.getSubtotalNeto() + ", totalIce=" + this.getTotalIce() + ", totalIva=" + this.getTotalIva() + ", total=" + this.getTotal() + ", totalNeto=" + this.getTotalNeto() + ", empresaId=" + this.getEmpresaId() + ", usuarioId=" + this.getUsuarioId() + ", detalles=" + this.getDetalles() + ", movimiento=" + this.getMovimiento() + ")";
    }
}

