/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.data.Perseo.clientes.crear;

import com.facturacion.config.properties.ClientesPerseoProperties;
import com.facturacion.config.validations.ValidEnum;
import com.facturacion.core.enums.TipoIdentificacionEnum;
import com.facturacion.data.DTO.request.CreateClienteRequestDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import lombok.Generated;

public class ClienteRequestDto {
    @JsonProperty(value="identificacion")
    @NotNull(message="El campo de identificaci\u00f3n es requerido.")
    @Size(min=9, max=20, message="El campo de identificci\u00f3n debe tener entre 9 y 20 caracteres")
    private @NotNull(message="El campo de identificaci\u00f3n es requerido.") @Size(min=9, max=20, message="El campo de identificci\u00f3n debe tener entre 9 y 20 caracteres") String identificacion;
    @JsonProperty(value="tipoidentificacion")
    @NotEmpty(message="El campo de tipo de identificaci\u00f3n es requerido.")
    @ValidEnum(enumClass=TipoIdentificacionEnum.class, message="El tipo de identificacion debe ser solo un caracter -> C: Cedula; R: Ruc; P: Pasaporte; F: Consumidor final", ignoreCase=false)
    private @NotEmpty(message="El campo de tipo de identificaci\u00f3n es requerido.") String tipoIdentificacion;
    @JsonProperty(value="codigocontable")
    private String codigoContable;
    @JsonProperty(value="razonsocial")
    @NotNull(message="La raz\u00f3n social es requerida")
    @Size(min=1, max=300, message="La raz\u00f3n social debe contener entre 1 y 300 caracteres")
    private @NotNull(message="La raz\u00f3n social es requerida") @Size(min=1, max=300, message="La raz\u00f3n social debe contener entre 1 y 300 caracteres") String razonSocial;
    @JsonProperty(value="nombrecomercial")
    private String nombreComercial;
    @JsonProperty(value="email")
    @NotEmpty(message="El email es requerido")
    @Email(message="El correo debe ser v\u00e1lido")
    @Size(max=300, message="El email no debe superar los 300 caracteres")
    private @NotEmpty(message="El email es requerido") @Email(message="El correo debe ser v\u00e1lido") @Size(max=300, message="El email no debe superar los 300 caracteres") String email;
    @JsonProperty(value="telefono1")
    @Pattern(regexp="^\\d{10,15}$", message="El tel\u00e9fono debe tener entre 10 y 15 d\u00edgitos")
    private @Pattern(regexp="^\\d{10,15}$", message="El tel\u00e9fono debe tener entre 10 y 15 d\u00edgitos") String telefono1;
    @JsonProperty(value="clientes_gruposid")
    @NotNull(message="el campo de clientes grupos id es requerido")
    private @NotNull(message="el campo de clientes grupos id es requerido") Integer clientesGruposId;
    @JsonProperty(value="direccion")
    private String direccion;
    @JsonProperty(value="estado")
    private Boolean estado;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMddHHmmss")
    private LocalDateTime fechaCreacion;
    @JsonProperty(value="tarifasid")
    private Integer tarifasId;
    @JsonProperty(value="forma_pago_empresaid")
    private Integer formaPagoEmpresaId;
    @JsonProperty(value="ordenvisita")
    private Integer ordenVisita;
    @JsonProperty(value="usuariocreacion")
    @NotEmpty(message="El usuario creador es requerido")
    @Size(max=25, message="El usuario no puede superar los 25 caracteres")
    private @NotEmpty(message="El usuario creador es requerido") @Size(max=25, message="El usuario no puede superar los 25 caracteres") String usuarioCreacion;

    public ClienteRequestDto(ClientesPerseoProperties props, String usuarioCreacion, CreateClienteRequestDto dto) {
        this.inicializarCreacionCliente(props, usuarioCreacion);
        this.fromClienteFacturaRequestDto(dto);
    }

    private void inicializarCreacionCliente(ClientesPerseoProperties props, String usuarioCreacion) {
        this.estado = true;
        this.fechaCreacion = LocalDateTime.now();
        this.codigoContable = props.getCodigoContable();
        this.usuarioCreacion = usuarioCreacion;
    }

    private void fromClienteFacturaRequestDto(CreateClienteRequestDto dto) {
        this.identificacion = dto.getIdentificacion();
        this.tipoIdentificacion = dto.getTipoIdentificacion();
        this.razonSocial = dto.getRazonSocial();
        this.nombreComercial = dto.getNombreComercial();
        this.email = dto.getEmail();
        this.telefono1 = dto.getTelefono1();
        this.direccion = dto.getDireccion();
        this.estado = dto.getEstado();
    }

    @Generated
    public String getIdentificacion() {
        return this.identificacion;
    }

    @Generated
    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    @Generated
    public String getCodigoContable() {
        return this.codigoContable;
    }

    @Generated
    public String getRazonSocial() {
        return this.razonSocial;
    }

    @Generated
    public String getNombreComercial() {
        return this.nombreComercial;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getTelefono1() {
        return this.telefono1;
    }

    @Generated
    public Integer getClientesGruposId() {
        return this.clientesGruposId;
    }

    @Generated
    public String getDireccion() {
        return this.direccion;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    @Generated
    public Integer getTarifasId() {
        return this.tarifasId;
    }

    @Generated
    public Integer getFormaPagoEmpresaId() {
        return this.formaPagoEmpresaId;
    }

    @Generated
    public Integer getOrdenVisita() {
        return this.ordenVisita;
    }

    @Generated
    public String getUsuarioCreacion() {
        return this.usuarioCreacion;
    }

    @JsonProperty(value="identificacion")
    @Generated
    public void setIdentificacion(String identificacion) {
        this.identificacion = identificacion;
    }

    @JsonProperty(value="tipoidentificacion")
    @Generated
    public void setTipoIdentificacion(String tipoIdentificacion) {
        this.tipoIdentificacion = tipoIdentificacion;
    }

    @JsonProperty(value="codigocontable")
    @Generated
    public void setCodigoContable(String codigoContable) {
        this.codigoContable = codigoContable;
    }

    @JsonProperty(value="razonsocial")
    @Generated
    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    @JsonProperty(value="nombrecomercial")
    @Generated
    public void setNombreComercial(String nombreComercial) {
        this.nombreComercial = nombreComercial;
    }

    @JsonProperty(value="email")
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="telefono1")
    @Generated
    public void setTelefono1(String telefono1) {
        this.telefono1 = telefono1;
    }

    @JsonProperty(value="clientes_gruposid")
    @Generated
    public void setClientesGruposId(Integer clientesGruposId) {
        this.clientesGruposId = clientesGruposId;
    }

    @JsonProperty(value="direccion")
    @Generated
    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    @JsonProperty(value="estado")
    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMddHHmmss")
    @Generated
    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @JsonProperty(value="tarifasid")
    @Generated
    public void setTarifasId(Integer tarifasId) {
        this.tarifasId = tarifasId;
    }

    @JsonProperty(value="forma_pago_empresaid")
    @Generated
    public void setFormaPagoEmpresaId(Integer formaPagoEmpresaId) {
        this.formaPagoEmpresaId = formaPagoEmpresaId;
    }

    @JsonProperty(value="ordenvisita")
    @Generated
    public void setOrdenVisita(Integer ordenVisita) {
        this.ordenVisita = ordenVisita;
    }

    @JsonProperty(value="usuariocreacion")
    @Generated
    public void setUsuarioCreacion(String usuarioCreacion) {
        this.usuarioCreacion = usuarioCreacion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClienteRequestDto)) {
            return false;
        }
        ClienteRequestDto other = (ClienteRequestDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$clientesGruposId = this.getClientesGruposId();
        Integer other$clientesGruposId = other.getClientesGruposId();
        if (this$clientesGruposId == null ? other$clientesGruposId != null : !((Object)this$clientesGruposId).equals(other$clientesGruposId)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Integer this$tarifasId = this.getTarifasId();
        Integer other$tarifasId = other.getTarifasId();
        if (this$tarifasId == null ? other$tarifasId != null : !((Object)this$tarifasId).equals(other$tarifasId)) {
            return false;
        }
        Integer this$formaPagoEmpresaId = this.getFormaPagoEmpresaId();
        Integer other$formaPagoEmpresaId = other.getFormaPagoEmpresaId();
        if (this$formaPagoEmpresaId == null ? other$formaPagoEmpresaId != null : !((Object)this$formaPagoEmpresaId).equals(other$formaPagoEmpresaId)) {
            return false;
        }
        Integer this$ordenVisita = this.getOrdenVisita();
        Integer other$ordenVisita = other.getOrdenVisita();
        if (this$ordenVisita == null ? other$ordenVisita != null : !((Object)this$ordenVisita).equals(other$ordenVisita)) {
            return false;
        }
        String this$identificacion = this.getIdentificacion();
        String other$identificacion = other.getIdentificacion();
        if (this$identificacion == null ? other$identificacion != null : !this$identificacion.equals(other$identificacion)) {
            return false;
        }
        String this$tipoIdentificacion = this.getTipoIdentificacion();
        String other$tipoIdentificacion = other.getTipoIdentificacion();
        if (this$tipoIdentificacion == null ? other$tipoIdentificacion != null : !this$tipoIdentificacion.equals(other$tipoIdentificacion)) {
            return false;
        }
        String this$codigoContable = this.getCodigoContable();
        String other$codigoContable = other.getCodigoContable();
        if (this$codigoContable == null ? other$codigoContable != null : !this$codigoContable.equals(other$codigoContable)) {
            return false;
        }
        String this$razonSocial = this.getRazonSocial();
        String other$razonSocial = other.getRazonSocial();
        if (this$razonSocial == null ? other$razonSocial != null : !this$razonSocial.equals(other$razonSocial)) {
            return false;
        }
        String this$nombreComercial = this.getNombreComercial();
        String other$nombreComercial = other.getNombreComercial();
        if (this$nombreComercial == null ? other$nombreComercial != null : !this$nombreComercial.equals(other$nombreComercial)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$telefono1 = this.getTelefono1();
        String other$telefono1 = other.getTelefono1();
        if (this$telefono1 == null ? other$telefono1 != null : !this$telefono1.equals(other$telefono1)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        if (this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion)) {
            return false;
        }
        LocalDateTime this$fechaCreacion = this.getFechaCreacion();
        LocalDateTime other$fechaCreacion = other.getFechaCreacion();
        if (this$fechaCreacion == null ? other$fechaCreacion != null : !((Object)this$fechaCreacion).equals(other$fechaCreacion)) {
            return false;
        }
        String this$usuarioCreacion = this.getUsuarioCreacion();
        String other$usuarioCreacion = other.getUsuarioCreacion();
        return !(this$usuarioCreacion == null ? other$usuarioCreacion != null : !this$usuarioCreacion.equals(other$usuarioCreacion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClienteRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $clientesGruposId = this.getClientesGruposId();
        result = result * 59 + ($clientesGruposId == null ? 43 : ((Object)$clientesGruposId).hashCode());
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Integer $tarifasId = this.getTarifasId();
        result = result * 59 + ($tarifasId == null ? 43 : ((Object)$tarifasId).hashCode());
        Integer $formaPagoEmpresaId = this.getFormaPagoEmpresaId();
        result = result * 59 + ($formaPagoEmpresaId == null ? 43 : ((Object)$formaPagoEmpresaId).hashCode());
        Integer $ordenVisita = this.getOrdenVisita();
        result = result * 59 + ($ordenVisita == null ? 43 : ((Object)$ordenVisita).hashCode());
        String $identificacion = this.getIdentificacion();
        result = result * 59 + ($identificacion == null ? 43 : $identificacion.hashCode());
        String $tipoIdentificacion = this.getTipoIdentificacion();
        result = result * 59 + ($tipoIdentificacion == null ? 43 : $tipoIdentificacion.hashCode());
        String $codigoContable = this.getCodigoContable();
        result = result * 59 + ($codigoContable == null ? 43 : $codigoContable.hashCode());
        String $razonSocial = this.getRazonSocial();
        result = result * 59 + ($razonSocial == null ? 43 : $razonSocial.hashCode());
        String $nombreComercial = this.getNombreComercial();
        result = result * 59 + ($nombreComercial == null ? 43 : $nombreComercial.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $telefono1 = this.getTelefono1();
        result = result * 59 + ($telefono1 == null ? 43 : $telefono1.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        LocalDateTime $fechaCreacion = this.getFechaCreacion();
        result = result * 59 + ($fechaCreacion == null ? 43 : ((Object)$fechaCreacion).hashCode());
        String $usuarioCreacion = this.getUsuarioCreacion();
        result = result * 59 + ($usuarioCreacion == null ? 43 : $usuarioCreacion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClienteRequestDto(identificacion=" + this.getIdentificacion() + ", tipoIdentificacion=" + this.getTipoIdentificacion() + ", codigoContable=" + this.getCodigoContable() + ", razonSocial=" + this.getRazonSocial() + ", nombreComercial=" + this.getNombreComercial() + ", email=" + this.getEmail() + ", telefono1=" + this.getTelefono1() + ", clientesGruposId=" + this.getClientesGruposId() + ", direccion=" + this.getDireccion() + ", estado=" + this.getEstado() + ", fechaCreacion=" + this.getFechaCreacion() + ", tarifasId=" + this.getTarifasId() + ", formaPagoEmpresaId=" + this.getFormaPagoEmpresaId() + ", ordenVisita=" + this.getOrdenVisita() + ", usuarioCreacion=" + this.getUsuarioCreacion() + ")";
    }
}

