/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.data.DTO.request;

import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import lombok.Generated;

public class DetalleItemRequest {
    @NotNull(message="El ID del producto es obligatorio")
    private @NotNull(message="El ID del producto es obligatorio") Integer productoId;
    @NotNull(message="La cantidad es obligatoria")
    @DecimalMin(value="0.0001", message="La cantidad debe ser mayor que 0")
    private @NotNull(message="La cantidad es obligatoria") @DecimalMin(value="0.0001", message="La cantidad debe ser mayor que 0") BigDecimal cantidad;
    @NotNull(message="El precio unitario es requerido")
    @DecimalMin(value="0.0001", message="El precio unitario debe ser mayor que 0")
    private @NotNull(message="El precio unitario es requerido") @DecimalMin(value="0.0001", message="El precio unitario debe ser mayor que 0") BigDecimal precioUnitarioSinIva;
    @DecimalMin(value="0.0000", inclusive=true, message="El descuento en valor debe ser mayor que 0")
    private @DecimalMin(value="0.0000", inclusive=true, message="El descuento en valor debe ser mayor que 0") BigDecimal descuentoValor;
    @NotNull(message="El IVA es obligatorio")
    @Min(value=0L)
    @Max(value=100L)
    private @NotNull(message="El IVA es obligatorio") @Min(value=0L) @Max(value=100L) Integer ivaPorcentaje;
    private String observacion;

    @Generated
    public DetalleItemRequest() {
    }

    @Generated
    public Integer getProductoId() {
        return this.productoId;
    }

    @Generated
    public BigDecimal getCantidad() {
        return this.cantidad;
    }

    @Generated
    public BigDecimal getPrecioUnitarioSinIva() {
        return this.precioUnitarioSinIva;
    }

    @Generated
    public BigDecimal getDescuentoValor() {
        return this.descuentoValor;
    }

    @Generated
    public Integer getIvaPorcentaje() {
        return this.ivaPorcentaje;
    }

    @Generated
    public String getObservacion() {
        return this.observacion;
    }

    @Generated
    public void setProductoId(Integer productoId) {
        this.productoId = productoId;
    }

    @Generated
    public void setCantidad(BigDecimal cantidad) {
        this.cantidad = cantidad;
    }

    @Generated
    public void setPrecioUnitarioSinIva(BigDecimal precioUnitarioSinIva) {
        this.precioUnitarioSinIva = precioUnitarioSinIva;
    }

    @Generated
    public void setDescuentoValor(BigDecimal descuentoValor) {
        this.descuentoValor = descuentoValor;
    }

    @Generated
    public void setIvaPorcentaje(Integer ivaPorcentaje) {
        this.ivaPorcentaje = ivaPorcentaje;
    }

    @Generated
    public void setObservacion(String observacion) {
        this.observacion = observacion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetalleItemRequest)) {
            return false;
        }
        DetalleItemRequest other = (DetalleItemRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$productoId = this.getProductoId();
        Integer other$productoId = other.getProductoId();
        if (this$productoId == null ? other$productoId != null : !((Object)this$productoId).equals(other$productoId)) {
            return false;
        }
        Integer this$ivaPorcentaje = this.getIvaPorcentaje();
        Integer other$ivaPorcentaje = other.getIvaPorcentaje();
        if (this$ivaPorcentaje == null ? other$ivaPorcentaje != null : !((Object)this$ivaPorcentaje).equals(other$ivaPorcentaje)) {
            return false;
        }
        BigDecimal this$cantidad = this.getCantidad();
        BigDecimal other$cantidad = other.getCantidad();
        if (this$cantidad == null ? other$cantidad != null : !((Object)this$cantidad).equals(other$cantidad)) {
            return false;
        }
        BigDecimal this$precioUnitarioSinIva = this.getPrecioUnitarioSinIva();
        BigDecimal other$precioUnitarioSinIva = other.getPrecioUnitarioSinIva();
        if (this$precioUnitarioSinIva == null ? other$precioUnitarioSinIva != null : !((Object)this$precioUnitarioSinIva).equals(other$precioUnitarioSinIva)) {
            return false;
        }
        BigDecimal this$descuentoValor = this.getDescuentoValor();
        BigDecimal other$descuentoValor = other.getDescuentoValor();
        if (this$descuentoValor == null ? other$descuentoValor != null : !((Object)this$descuentoValor).equals(other$descuentoValor)) {
            return false;
        }
        String this$observacion = this.getObservacion();
        String other$observacion = other.getObservacion();
        return !(this$observacion == null ? other$observacion != null : !this$observacion.equals(other$observacion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DetalleItemRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $productoId = this.getProductoId();
        result = result * 59 + ($productoId == null ? 43 : ((Object)$productoId).hashCode());
        Integer $ivaPorcentaje = this.getIvaPorcentaje();
        result = result * 59 + ($ivaPorcentaje == null ? 43 : ((Object)$ivaPorcentaje).hashCode());
        BigDecimal $cantidad = this.getCantidad();
        result = result * 59 + ($cantidad == null ? 43 : ((Object)$cantidad).hashCode());
        BigDecimal $precioUnitarioSinIva = this.getPrecioUnitarioSinIva();
        result = result * 59 + ($precioUnitarioSinIva == null ? 43 : ((Object)$precioUnitarioSinIva).hashCode());
        BigDecimal $descuentoValor = this.getDescuentoValor();
        result = result * 59 + ($descuentoValor == null ? 43 : ((Object)$descuentoValor).hashCode());
        String $observacion = this.getObservacion();
        result = result * 59 + ($observacion == null ? 43 : $observacion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DetalleItemRequest(productoId=" + this.getProductoId() + ", cantidad=" + this.getCantidad() + ", precioUnitarioSinIva=" + this.getPrecioUnitarioSinIva() + ", descuentoValor=" + this.getDescuentoValor() + ", ivaPorcentaje=" + this.getIvaPorcentaje() + ", observacion=" + this.getObservacion() + ")";
    }
}

