/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.data.DTO.request;

import com.facturacion.config.validations.ValidEnum;
import com.facturacion.core.enums.TipoIdentificacionEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;

public class CreateClienteRequestDto {
    @JsonProperty(value="identificacion")
    @NotNull(message="El campo de identificaci\u00f3n es requerido.")
    @Size(min=9, max=20, message="El campo de identificaci\u00f3n debe tener entre 9 y 20 caracteres")
    private @NotNull(message="El campo de identificaci\u00f3n es requerido.") @Size(min=9, max=20, message="El campo de identificaci\u00f3n debe tener entre 9 y 20 caracteres") String identificacion;
    @JsonProperty(value="tipoIdentificacion")
    @NotEmpty(message="El campo de tipo de identificaci\u00f3n es requerido.")
    @ValidEnum(enumClass=TipoIdentificacionEnum.class, message="El tipo de identificacion debe ser solo un caracter -> C: Cedula; R: Ruc; P: Pasaporte; F: Consumidor final", ignoreCase=false)
    private @NotEmpty(message="El campo de tipo de identificaci\u00f3n es requerido.") String tipoIdentificacion;
    @JsonProperty(value="razonSocial")
    @NotNull(message="La raz\u00f3n social es requerida")
    @Size(min=1, max=300, message="La raz\u00f3n social debe contener entre 1 y 300 caracteres")
    private @NotNull(message="La raz\u00f3n social es requerida") @Size(min=1, max=300, message="La raz\u00f3n social debe contener entre 1 y 300 caracteres") String razonSocial;
    @JsonProperty(value="nombreComercial")
    private String nombreComercial;
    @JsonProperty(value="email")
    @NotEmpty(message="El email es requerido")
    @Email(message="El correo debe ser v\u00e1lido")
    @Size(max=300, message="El email no debe superar los 300 caracteres")
    private @NotEmpty(message="El email es requerido") @Email(message="El correo debe ser v\u00e1lido") @Size(max=300, message="El email no debe superar los 300 caracteres") String email;
    @JsonProperty(value="telefono1")
    @Pattern(regexp="^\\d{10,15}$", message="El tel\u00e9fono debe tener entre 10 y 15 d\u00edgitos")
    private @Pattern(regexp="^\\d{10,15}$", message="El tel\u00e9fono debe tener entre 10 y 15 d\u00edgitos") String telefono1;
    @JsonProperty(value="direccion")
    private String direccion;
    @JsonProperty(value="estado")
    private Boolean estado;

    @Generated
    public String getIdentificacion() {
        return this.identificacion;
    }

    @Generated
    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    @Generated
    public String getRazonSocial() {
        return this.razonSocial;
    }

    @Generated
    public String getNombreComercial() {
        return this.nombreComercial;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getTelefono1() {
        return this.telefono1;
    }

    @Generated
    public String getDireccion() {
        return this.direccion;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @JsonProperty(value="identificacion")
    @Generated
    public void setIdentificacion(String identificacion) {
        this.identificacion = identificacion;
    }

    @JsonProperty(value="tipoIdentificacion")
    @Generated
    public void setTipoIdentificacion(String tipoIdentificacion) {
        this.tipoIdentificacion = tipoIdentificacion;
    }

    @JsonProperty(value="razonSocial")
    @Generated
    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    @JsonProperty(value="nombreComercial")
    @Generated
    public void setNombreComercial(String nombreComercial) {
        this.nombreComercial = nombreComercial;
    }

    @JsonProperty(value="email")
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="telefono1")
    @Generated
    public void setTelefono1(String telefono1) {
        this.telefono1 = telefono1;
    }

    @JsonProperty(value="direccion")
    @Generated
    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    @JsonProperty(value="estado")
    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateClienteRequestDto)) {
            return false;
        }
        CreateClienteRequestDto other = (CreateClienteRequestDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$identificacion = this.getIdentificacion();
        String other$identificacion = other.getIdentificacion();
        if (this$identificacion == null ? other$identificacion != null : !this$identificacion.equals(other$identificacion)) {
            return false;
        }
        String this$tipoIdentificacion = this.getTipoIdentificacion();
        String other$tipoIdentificacion = other.getTipoIdentificacion();
        if (this$tipoIdentificacion == null ? other$tipoIdentificacion != null : !this$tipoIdentificacion.equals(other$tipoIdentificacion)) {
            return false;
        }
        String this$razonSocial = this.getRazonSocial();
        String other$razonSocial = other.getRazonSocial();
        if (this$razonSocial == null ? other$razonSocial != null : !this$razonSocial.equals(other$razonSocial)) {
            return false;
        }
        String this$nombreComercial = this.getNombreComercial();
        String other$nombreComercial = other.getNombreComercial();
        if (this$nombreComercial == null ? other$nombreComercial != null : !this$nombreComercial.equals(other$nombreComercial)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$telefono1 = this.getTelefono1();
        String other$telefono1 = other.getTelefono1();
        if (this$telefono1 == null ? other$telefono1 != null : !this$telefono1.equals(other$telefono1)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        return !(this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateClienteRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $identificacion = this.getIdentificacion();
        result = result * 59 + ($identificacion == null ? 43 : $identificacion.hashCode());
        String $tipoIdentificacion = this.getTipoIdentificacion();
        result = result * 59 + ($tipoIdentificacion == null ? 43 : $tipoIdentificacion.hashCode());
        String $razonSocial = this.getRazonSocial();
        result = result * 59 + ($razonSocial == null ? 43 : $razonSocial.hashCode());
        String $nombreComercial = this.getNombreComercial();
        result = result * 59 + ($nombreComercial == null ? 43 : $nombreComercial.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $telefono1 = this.getTelefono1();
        result = result * 59 + ($telefono1 == null ? 43 : $telefono1.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateClienteRequestDto(identificacion=" + this.getIdentificacion() + ", tipoIdentificacion=" + this.getTipoIdentificacion() + ", razonSocial=" + this.getRazonSocial() + ", nombreComercial=" + this.getNombreComercial() + ", email=" + this.getEmail() + ", telefono1=" + this.getTelefono1() + ", direccion=" + this.getDireccion() + ", estado=" + this.getEstado() + ")";
    }
}

