/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.service.slack;

import com.facturacion.client.slack.ApiSlackClient;
import com.facturacion.data.DTO.slack.RequestEventDto;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class NotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationService.class);
    private final ApiSlackClient apiSlackClient;

    public void enviarNotificacionError(String titulo, String message) {
        try {
            String templateError = "*%s*\n\n%s\n".formatted(titulo, message);
            RequestEventDto request = RequestEventDto.builder().text(templateError).iconEmoji(":rotating_light:").build();
            this.apiSlackClient.notificarMensajeClienteApi(request).doOnNext(response -> log.info("Notificaci\u00f3n enviada: {}", response)).onErrorResume(ex -> {
                log.error("Error al enviar notificaci\u00f3n: {}", (Object)ex.getMessage(), ex);
                return Mono.empty();
            }).subscribe();
        }
        catch (Exception ex2) {
            log.error("Error inesperado en enviarNotificacionError: {}", (Object)ex2.getMessage(), (Object)ex2);
        }
    }

    @Generated
    public NotificationService(ApiSlackClient apiSlackClient) {
        this.apiSlackClient = apiSlackClient;
    }
}

