/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.service.impl;

import com.facturacion.cache.PuntoEmisionCacheService;
import com.facturacion.core.service.SecuenciaService;
import com.facturacion.data.Perseo.secuencias.Secuencia;
import com.facturacion.exceptions.ApiException;
import com.facturacion.exceptions.CustomException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class SecuenciaServiceImpl
implements SecuenciaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecuenciaServiceImpl.class);
    private final PuntoEmisionCacheService emisionCacheService;

    public Mono<Secuencia> obtenerSecuenciaByPuntoEmision(String puntoEmision) {
        return this.emisionCacheService.obtenerListaPuntosEmision().flatMapMany(response -> Flux.fromIterable((Iterable)response)).filter(s -> puntoEmision.equals(s.puntoEmision())).next().switchIfEmpty(Mono.error((Throwable)new CustomException("No se encontr\u00f3 secuencia con ese punto de emisi\u00f3n", HttpStatus.NOT_FOUND))).onErrorResume(ApiException.class, ex -> {
            log.info("response en service {}", (Object)ex.getError());
            return Mono.error((Throwable)ex);
        });
    }

    @Generated
    public SecuenciaServiceImpl(PuntoEmisionCacheService emisionCacheService) {
        this.emisionCacheService = emisionCacheService;
    }
}

