/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.service.impl;

import com.facturacion.cache.FormasPagoCacheService;
import com.facturacion.core.service.FormasPagoService;
import com.facturacion.data.Perseo.formasPago.empresa.FormasPagoEmpresa;
import com.facturacion.data.Perseo.formasPago.sri.FormasPagoSri;
import com.facturacion.exceptions.ApiException;
import com.facturacion.exceptions.CustomException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class FormasPagoServiceImpl
implements FormasPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormasPagoServiceImpl.class);
    private final FormasPagoCacheService formasPagoCacheService;

    public Mono<FormasPagoEmpresa> obtenerFormaPagoEmpresaPorId(String idFormaPagoEmpresa) {
        return this.formasPagoCacheService.obtenerListaFormasPagoEmpresa().flatMapMany(response -> Flux.fromIterable((Iterable)response)).filter(s -> idFormaPagoEmpresa.equals(s.formaPagoEmpresaId())).next().switchIfEmpty(Mono.error((Throwable)new CustomException("No se encontr\u00f3 la forma de pago de la empresa", HttpStatus.NOT_FOUND))).onErrorResume(ApiException.class, ex -> {
            log.info("response en service {}", (Object)ex.getError());
            return Mono.error((Throwable)ex);
        });
    }

    public Mono<FormasPagoSri> obtenerFormaPagoSriPorCodigo(String codigoFormaPago) {
        return this.formasPagoCacheService.obtenerListaFormasPagoSri().flatMapMany(response -> Flux.fromIterable((Iterable)response)).filter(s -> codigoFormaPago.equals(s.formaPagoSriCodigo())).next().switchIfEmpty(Mono.error((Throwable)new CustomException("No se encontr\u00f3 la forma de pago del SRI", HttpStatus.NOT_FOUND))).onErrorResume(ApiException.class, ex -> {
            log.info("response en service {}", (Object)ex.getError());
            return Mono.error((Throwable)ex);
        });
    }

    @Generated
    public FormasPagoServiceImpl(FormasPagoCacheService formasPagoCacheService) {
        this.formasPagoCacheService = formasPagoCacheService;
    }
}

