/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.service.impl;

import com.facturacion.client.perseo.ApiClientesClient;
import com.facturacion.config.properties.ClientesPerseoProperties;
import com.facturacion.core.service.ClienteService;
import com.facturacion.data.DTO.request.CreateClienteRequestDto;
import com.facturacion.data.Perseo.clientes.Cliente;
import com.facturacion.data.Perseo.clientes.ClienteCreatedDto;
import com.facturacion.data.Perseo.clientes.crear.ClienteRequestDto;
import com.facturacion.data.query.QueryClientesDto;
import com.facturacion.exceptions.ApiException;
import com.facturacion.exceptions.CustomException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ClienteServiceImpl
implements ClienteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClienteServiceImpl.class);
    private final ApiClientesClient apiClientesClient;
    private final ClientesPerseoProperties clientesPerseoProperties;

    public Mono<Cliente> obtenerClientePorIdentificacion(String identificacion) {
        QueryClientesDto clienteQueryReq = new QueryClientesDto(null, null, identificacion, null);
        return this.apiClientesClient.obtenerClienteApi(clienteQueryReq).flatMapMany(response -> Flux.fromIterable((Iterable)response.clientes())).filter(s -> identificacion.equals(s.identificacion()) && s.estado() == true).next().switchIfEmpty(Mono.error((Throwable)new CustomException("No se encontr\u00f3 el cliente con la identificaci\u00f3n: <" + identificacion + "> en la base de datos, primero registrelo", HttpStatus.NOT_FOUND))).onErrorResume(ApiException.class, ex -> {
            log.error("response en service {}", (Object)ex.getError());
            return Mono.error((Throwable)ex);
        });
    }

    public Mono<ClienteCreatedDto> registrarNuevoCliente(CreateClienteRequestDto clienteRequestDto) {
        ClienteRequestDto model = new ClienteRequestDto(this.clientesPerseoProperties, "USER", clienteRequestDto);
        return this.apiClientesClient.crearClienteApi(model).flatMap(response -> {
            log.info("response client created {}", response);
            if (response.clientes() == null || response.clientes().isEmpty()) {
                return Mono.error((Throwable)new CustomException("No se encontr\u00f3 una respuesta v\u00e1lida al crear el usuario", HttpStatus.NOT_FOUND));
            }
            return Mono.just((Object)((ClienteCreatedDto)response.clientes().get(0)));
        }).switchIfEmpty(Mono.error((Throwable)new CustomException("No se encontr\u00f3 una respuesta v\u00e1lida al crear el usuario", HttpStatus.NOT_FOUND))).onErrorResume(ApiException.class, ex -> {
            log.error("response en service {}", (Object)ex.getError());
            return Mono.error((Throwable)ex);
        });
    }

    @Generated
    public ClienteServiceImpl(ApiClientesClient apiClientesClient, ClientesPerseoProperties clientesPerseoProperties) {
        this.apiClientesClient = apiClientesClient;
        this.clientesPerseoProperties = clientesPerseoProperties;
    }
}

