/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.service.calculos;

import com.facturacion.data.Perseo.facturar.DetalleFacturaDto;
import com.facturacion.data.Perseo.facturar.FacturaTotales;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FacturaCalculatorService {
    public FacturaTotales calcularTotales(List<DetalleFacturaDto> detalles) {
        FacturaTotales t = new FacturaTotales();
        for (DetalleFacturaDto item : detalles) {
            BigDecimal cantidad = item.getCantidad();
            BigDecimal precioUnitario = item.getPrecio();
            BigDecimal descuentoUnitario = item.getDescuento() != null ? item.getDescuento() : BigDecimal.ZERO;
            BigDecimal ivaPorcentaje = BigDecimal.valueOf(item.getIva().intValue());
            BigDecimal precioBruto = precioUnitario.multiply(cantidad);
            BigDecimal descuentoTotal = descuentoUnitario.multiply(cantidad);
            BigDecimal precioNeto = precioBruto.subtract(descuentoTotal);
            BigDecimal ivaTotal = BigDecimal.ZERO;
            if (ivaPorcentaje.compareTo(BigDecimal.ZERO) > 0) {
                ivaTotal = precioNeto.multiply(ivaPorcentaje).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP);
            }
            t.setSubtotal(t.getSubtotal().add(precioBruto));
            t.setTotalDescuento(t.getTotalDescuento().add(descuentoTotal));
            t.setSubtotalneto(t.getSubtotalneto().add(precioNeto));
            t.setTotalIva(t.getTotalIva().add(ivaTotal));
            if (ivaPorcentaje.compareTo(BigDecimal.ZERO) > 0) {
                t.setSubtotalconiva(t.getSubtotalconiva().add(precioNeto));
                continue;
            }
            t.setSubtotalsiniva(t.getSubtotalsiniva().add(precioNeto));
        }
        t.setTotalIce(BigDecimal.ZERO);
        BigDecimal total = t.getSubtotalneto().add(t.getTotalIva());
        t.setTotal(total);
        t.setTotalneto(total);
        this.redondearTotales(t);
        return t;
    }

    private void redondearTotales(FacturaTotales t) {
        t.setSubtotal(t.getSubtotal().setScale(2, RoundingMode.HALF_UP));
        t.setSubtotalsiniva(t.getSubtotalsiniva().setScale(2, RoundingMode.HALF_UP));
        t.setSubtotalconiva(t.getSubtotalconiva().setScale(2, RoundingMode.HALF_UP));
        t.setSubtotalneto(t.getSubtotalneto().setScale(2, RoundingMode.HALF_UP));
        t.setTotalDescuento(t.getTotalDescuento().setScale(2, RoundingMode.HALF_UP));
        t.setTotalIva(t.getTotalIva().setScale(2, RoundingMode.HALF_UP));
        t.setTotalIce(t.getTotalIce().setScale(2, RoundingMode.HALF_UP));
        t.setTotal(t.getTotal().setScale(2, RoundingMode.HALF_UP));
        t.setTotalneto(t.getTotalneto().setScale(2, RoundingMode.HALF_UP));
    }
}

