/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.repository;

import com.facturacion.data.Perseo.facturar.FacturaDto;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FacturaRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacturaRepository.class);
    private final JdbcTemplate jdbcTemplate;

    @Transactional
    public Long insertarCabeceraYObtenerId(FacturaDto dto) {
        String sql = "    INSERT INTO facturacionperseo.t_factura (\n        establecimiento, punto_emision, secuencial, sri_documentos_codigo,\n        forma_pago_empresa_id, forma_pago_sri_codigo,\n        clientes_id, clientes_sucursales_id, secuencias_id, cajas_id, centros_costos_id,\n        almacenes_id, facturadores_id, vendedores_id, tarifas_id,\n        emision, vence, fecha_creacion, usuario_creacion,\n        dispositivo, uuid,\n        concepto, observacion,\n        subtotal, subtotal_sin_iva, subtotal_con_iva, total_descuento,\n        subtotal_neto, total_ice, total_iva, total, total_neto\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement(sql, 1);
            ps.setString(1, dto.getEstablecimiento());
            ps.setString(2, dto.getPuntoEmision());
            ps.setString(3, dto.getSecuencial());
            ps.setString(4, dto.getSriDocumentosCodigo());
            ps.setString(5, dto.getFormaPagoEmpresaId());
            ps.setString(6, dto.getFormaPagoSriCodigo());
            ps.setObject(7, (Object)dto.getClientesId(), 4);
            ps.setObject(8, (Object)dto.getClientesSucursalesId(), 4);
            ps.setObject(9, (Object)dto.getSecuenciasId(), 4);
            ps.setObject(10, (Object)dto.getCajasId(), 4);
            ps.setObject(11, (Object)dto.getCentrosCostosId(), 4);
            ps.setObject(12, (Object)dto.getAlmacenesId(), 4);
            ps.setObject(13, (Object)dto.getFacturadoresId(), 4);
            ps.setObject(14, (Object)dto.getVendedoresId(), 4);
            ps.setObject(15, (Object)dto.getTarifasId(), 4);
            ps.setDate(16, Date.valueOf(dto.getEmision()));
            ps.setDate(17, Date.valueOf(dto.getVence()));
            ps.setTimestamp(18, Timestamp.valueOf(dto.getFechaCreacion()));
            ps.setString(19, dto.getUsuarioCreacion());
            ps.setString(20, dto.getDispositivo());
            ps.setString(21, dto.getUuid());
            ps.setString(22, dto.getConcepto());
            ps.setString(23, dto.getObservacion());
            ps.setBigDecimal(24, dto.getSubtotal());
            ps.setBigDecimal(25, dto.getSubtotalSinIva());
            ps.setBigDecimal(26, dto.getSubtotalConIva());
            ps.setBigDecimal(27, dto.getTotalDescuento());
            ps.setBigDecimal(28, dto.getSubtotalNeto());
            ps.setBigDecimal(29, dto.getTotalIce());
            ps.setBigDecimal(30, dto.getTotalIva());
            ps.setBigDecimal(31, dto.getTotal());
            ps.setBigDecimal(32, dto.getTotalNeto());
            return ps;
        }, (KeyHolder)keyHolder);
        Map keys = keyHolder.getKeys();
        if (keys == null || !keys.containsKey("id")) {
            log.error("No se pudo obtener el ID generado de la factura.");
            return null;
        }
        Number id = (Number)keys.get("id");
        return id.longValue();
    }

    @Generated
    public FacturaRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

