/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.repository;

import com.facturacion.data.Perseo.facturar.DetalleFacturaDto;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class FacturaDetalleRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacturaDetalleRepository.class);
    private final JdbcTemplate jdbcTemplate;
    private static final String SQL_INSERT = "    INSERT INTO facturacionperseo.t_factura_detalle (\n        factura_id,\n        productos_id, centros_costos_id, almacenes_id, medidas_id,\n        cantidad_digitada, cantidad_factor, cantidad,\n        ctrl_negativos, precio, precio_visible, precio_iva,\n        descuento, descuento_valor, costo,\n        iva, servicio,\n        informacion, informacion_detalle\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";

    private void insertarDetalle(DetalleFacturaDto d, Long facturaId) {
        this.jdbcTemplate.update(SQL_INSERT, new Object[]{facturaId, d.getProductosId(), d.getCentrosCostosId(), d.getAlmacenesId(), d.getMedidasId(), d.getCantidadDigitada(), d.getCantidadFactor(), d.getCantidad(), d.getCtrlNegativos(), d.getPrecio(), d.getPrecioVisible(), d.getPrecioIva(), d.getDescuento(), d.getDescuentoValor(), d.getCosto(), d.getIva(), d.getServicio(), d.getInformacion(), d.getInformacionDetalle()});
    }

    public void insertarDetalles(List<DetalleFacturaDto> detalles, Long facturaId) {
        for (DetalleFacturaDto d : detalles) {
            this.insertarDetalle(d, facturaId);
        }
    }

    @Generated
    public FacturaDetalleRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

