/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.mappers.perseo.facturacion;

import com.facturacion.config.properties.FacturacionProperties;
import com.facturacion.data.DTO.request.DetalleItemRequest;
import com.facturacion.data.Perseo.facturar.DetalleFacturaDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

public class DetalleItemMapper {
    public DetalleFacturaDto mapToDetalleFactura(DetalleItemRequest dto, FacturacionProperties props) {
        DetalleFacturaDto model = new DetalleFacturaDto();
        model.setProductosId(dto.getProductoId());
        model.setCantidadDigitada(dto.getCantidad());
        model.setCantidad(dto.getCantidad());
        model.setCentrosCostosId(props.getCentroCostosId());
        model.setAlmacenesId(props.getAlmacenesId());
        model.setMedidasId(props.getMedidasId());
        model.setCantidadFactor(props.getCantidadFactor());
        model.setCtrlNegativos(Boolean.FALSE);
        model.setPrecio(dto.getPrecioUnitarioSinIva());
        model.setPrecioVisible(dto.getPrecioUnitarioSinIva());
        BigDecimal ivaDecimal = BigDecimal.valueOf(dto.getIvaPorcentaje().intValue()).divide(BigDecimal.valueOf(100L));
        BigDecimal precioConIva = dto.getPrecioUnitarioSinIva().multiply(BigDecimal.ONE.add(ivaDecimal)).setScale(4, RoundingMode.HALF_UP);
        model.setPrecioIva(precioConIva);
        BigDecimal descuentoValor = Optional.ofNullable(dto.getDescuentoValor()).orElse(BigDecimal.ZERO);
        model.setDescuento(descuentoValor);
        model.setDescuentoValor(descuentoValor);
        model.setIva(dto.getIvaPorcentaje());
        model.setServicio(Boolean.TRUE);
        model.setInformacion("Producto");
        model.setInformacionDetalle(dto.getObservacion() != null ? dto.getObservacion() : "Sin observaci\u00f3n");
        return model;
    }
}

