/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.controller;

import com.facturacion.core.service.ClienteService;
import com.facturacion.data.DTO.request.CreateClienteRequestDto;
import com.facturacion.data.Perseo.clientes.buscar.BuscarClienteIdentificacionDto;
import com.facturacion.utils.ApiResponse;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"client"})
public class ClientsController {
    private final ClienteService clienteService;

    public ClientsController(ClienteService clienteService) {
        this.clienteService = clienteService;
    }

    @PostMapping(value={"crear"})
    public Mono<ResponseEntity<?>> crearNuevoCliente(@RequestBody @Valid CreateClienteRequestDto clienteRequestDto) {
        return this.clienteService.registrarNuevoCliente(clienteRequestDto).flatMap(res -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)res))));
    }

    @PostMapping(value={"buscar4identificacion"})
    Mono<ResponseEntity<?>> obtenerClientePorIdentificacion(@RequestBody @Valid BuscarClienteIdentificacionDto body) {
        return this.clienteService.obtenerClientePorIdentificacion(body.identificacionCliente()).flatMap(res -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)res))));
    }
}

