/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.controller;

import com.facturacion.core.service.CacheService;
import com.facturacion.utils.ApiResponse;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"cache"})
public class CacheController {
    private final CacheService cacheService;

    @DeleteMapping(value={"/all"})
    public ResponseEntity<?> limpiarTodos() {
        this.cacheService.limpiarTodosLosCaches();
        return ResponseEntity.ok((Object)ApiResponse.okMessageNoBody((String)"Caches limpiados correctamente"));
    }

    @DeleteMapping(value={"/{nombre}"})
    public ResponseEntity<?> limpiarPorNombre(@PathVariable String nombre) {
        this.cacheService.limpiarCache(nombre);
        return ResponseEntity.ok((Object)ApiResponse.okMessageNoBody((String)"\"Cache '\" + nombre + \"' limpiado\""));
    }

    @Generated
    public CacheController(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

