/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.core.controller;

import com.facturacion.auth.service.AutenticationService;
import com.facturacion.data.DTO.auth.AuthLoginRequest;
import com.facturacion.utils.ApiResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"auth"})
@Tag(name="Autenticaci\u00f3n", description="Login y emisi\u00f3n de token de acceso")
public class AuthController {
    private final AutenticationService autenticationService;

    @PostMapping(value={"login"})
    @Operation(summary="Autenticaci\u00f3n de usuario", description="Recibe credenciales de usuario y devuelve un token JWT de acceso v\u00e1lido.")
    Mono<ResponseEntity<?>> authLogin(@RequestBody @Valid AuthLoginRequest authRequest) {
        return this.autenticationService.login(authRequest).map(ApiResponse::ok).map(ResponseEntity::ok);
    }

    @Generated
    public AuthController(AutenticationService autenticationService) {
        this.autenticationService = autenticationService;
    }
}

