/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.config.validations.validator;

import com.facturacion.config.validations.ValidEnum;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EnumValidator
implements ConstraintValidator<ValidEnum, String> {
    private List<String> acceptedValues;
    private boolean ignoreCase;

    public void initialize(ValidEnum annotation) {
        this.ignoreCase = annotation.ignoreCase();
        Class enumSelected = annotation.enumClass();
        Enum[] enumConstants = (Enum[])enumSelected.getEnumConstants();
        this.acceptedValues = this.ignoreCase ? Arrays.stream(enumConstants).map(e -> e.name().toLowerCase()).collect(Collectors.toList()) : Arrays.stream(enumConstants).map(Enum::name).collect(Collectors.toList());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return this.ignoreCase ? this.acceptedValues.contains(value.toLowerCase()) : this.acceptedValues.contains(value);
    }
}

