/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.config.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheConfig {
    @Bean
    Caffeine<Object, Object> caffeineConfig() {
        return Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).maximumSize(500L);
    }

    @Bean
    CacheManager cacheManager(Caffeine<Object, Object> caffeine) {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager(new String[]{"listaTipoIva", "formasPagoEmpresa", "formasPagoSRI"});
        cacheManager.setAsyncCacheMode(true);
        cacheManager.setCaffeine(caffeine);
        return cacheManager;
    }
}

