/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.config;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

@Configuration
public class WebClientConfig {
    @Bean
    WebClient webClient() {
        ConnectionProvider provider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"custom-connection-pool").maxConnections(100)).pendingAcquireTimeout(Duration.ofSeconds(10L))).build();
        HttpClient httpClient = (HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)provider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(5L, TimeUnit.SECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(5L, TimeUnit.SECONDS)));
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).defaultHeader("Content-Type", new String[]{"application/json"}).build();
    }
}

