/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.client.slack;

import com.facturacion.client.WebClientErrorHandler;
import com.facturacion.config.properties.SlackProperties;
import com.facturacion.data.DTO.slack.RequestEventDto;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiSlackClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSlackClient.class);
    private final WebClient webClient;
    private final SlackProperties slackProps;

    public Mono<String> notificarMensajeClienteApi(RequestEventDto request) {
        request.setUsername(this.slackProps.getUsername());
        log.info("slack request {}", (Object)request);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.slackProps.getWebhookUrl(), new Object[0])).bodyValue((Object)request).retrieve().onStatus(statusCode -> statusCode.is4xxClientError() || statusCode.is5xxServerError(), response -> WebClientErrorHandler.handle((ClientResponse)response, String.class, (String)this.slackProps.getWebhookUrl())).bodyToMono(String.class);
    }

    @Generated
    public ApiSlackClient(WebClient webClient, SlackProperties slackProps) {
        this.webClient = webClient;
        this.slackProps = slackProps;
    }
}

