/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.client.perseo;

import com.facturacion.client.WebClientErrorHandler;
import com.facturacion.client.util.ApiRequestBuilder;
import com.facturacion.config.properties.WebClientPerseoProperties;
import com.facturacion.data.Perseo.clientes.CienteQueryResponse;
import com.facturacion.data.Perseo.clientes.ClienteCrateResponse;
import com.facturacion.data.Perseo.clientes.crear.ClienteRequestDto;
import com.facturacion.data.Perseo.clientes.crear.RequestCreateClientsPerseo;
import com.facturacion.data.query.QueryClientesDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiClientesClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiClientesClient.class);
    private final WebClient webClient;
    private final WebClientPerseoProperties perseoProps;
    private final ObjectMapper objectMapper;

    public Mono<CienteQueryResponse> obtenerClienteApi(QueryClientesDto request) {
        Map body = ApiRequestBuilder.withApiKey((String)this.perseoProps.getApikey(), (Object)request, (ObjectMapper)this.objectMapper);
        log.info("client request {}", (Object)body);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.perseoProps.getQueryClientes(), new Object[0])).bodyValue((Object)body).retrieve().onStatus(statusCode -> statusCode.is4xxClientError() || statusCode.is5xxServerError(), response -> WebClientErrorHandler.handle((ClientResponse)response, String.class, (String)this.perseoProps.getSecuenciasUrl())).bodyToMono(CienteQueryResponse.class);
    }

    public Mono<ClienteCrateResponse> crearClienteApi(ClienteRequestDto request) {
        RequestCreateClientsPerseo requestBody = RequestCreateClientsPerseo.fromSingleCliente((ClienteRequestDto)request);
        Map body = ApiRequestBuilder.withApiKey((String)this.perseoProps.getApikey(), (Object)requestBody, (ObjectMapper)this.objectMapper);
        log.info("client create request {}, endpoint {}", (Object)body, (Object)this.perseoProps.getCrearCliente());
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.perseoProps.getCrearCliente(), new Object[0])).bodyValue((Object)body).retrieve().onStatus(statusCode -> statusCode.is4xxClientError() || statusCode.is5xxServerError(), response -> WebClientErrorHandler.handle((ClientResponse)response, String.class, (String)this.perseoProps.getSecuenciasUrl())).bodyToMono(ClienteCrateResponse.class);
    }

    @Generated
    public ApiClientesClient(WebClient webClient, WebClientPerseoProperties perseoProps, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.perseoProps = perseoProps;
        this.objectMapper = objectMapper;
    }
}

