/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.client.auth;

import com.facturacion.client.WebClientErrorHandler;
import com.facturacion.config.properties.AuthProperties;
import com.facturacion.data.DTO.auth.AuthLoginRequest;
import com.facturacion.data.DTO.auth.AuthTokenResponse;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiAuthClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiAuthClient.class);
    private final WebClient webClient;
    private final AuthProperties authProperties;

    public Mono<AuthTokenResponse> notificarMensajeClienteApi(AuthLoginRequest authRequest) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"grant_type", (Object)this.authProperties.getGrantType());
        formData.add((Object)"client_id", (Object)this.authProperties.getClientId());
        formData.add((Object)"client_secret", (Object)this.authProperties.getClientSecret());
        formData.add((Object)"username", (Object)authRequest.getUsername());
        formData.add((Object)"password", (Object)authRequest.getPassword());
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.authProperties.getTokenUri(), new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData)).retrieve().onStatus(statusCode -> statusCode.is4xxClientError() || statusCode.is5xxServerError(), response -> WebClientErrorHandler.handle((ClientResponse)response, JsonNode.class, (String)"Auth api keycloak")).bodyToMono(AuthTokenResponse.class);
    }

    @Generated
    public ApiAuthClient(WebClient webClient, AuthProperties authProperties) {
        this.webClient = webClient;
        this.authProperties = authProperties;
    }
}

