/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.client;

import com.facturacion.client.ErrorResponse;
import com.facturacion.exceptions.ApiException;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

public class WebClientErrorHandler {
    public static <T> Mono<? extends Throwable> handle(ClientResponse response, Class<T> errorType, String endpoint) {
        HttpStatusCode status = response.statusCode();
        return response.bodyToMono(errorType).switchIfEmpty(Mono.justOrEmpty(null)).flatMap(body -> {
            ErrorResponse error = new ErrorResponse(status.value(), "Error desde API externa", endpoint, body);
            return Mono.error((Throwable)new ApiException(error));
        });
    }
}

