/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.cache;

import com.facturacion.client.perseo.ApiCodigoSriClient;
import com.facturacion.data.Perseo.tiposIva.TipoIva;
import com.facturacion.exceptions.ApiException;
import com.facturacion.exceptions.CustomException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class TipoIvaCacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TipoIvaCacheService.class);
    private final ApiCodigoSriClient apiCodigoSriClient;

    @Cacheable(value={"listaTipoIva"})
    public Mono<List<TipoIva>> obtenerListaTipoIva() {
        log.info("Listando los tipos de iva desde la api");
        return this.apiCodigoSriClient.obtenerTiposDeIva().switchIfEmpty(Mono.error((Throwable)new CustomException("No se encontr\u00f3 la lista de tipos de ivas", HttpStatus.NOT_FOUND))).flatMap(res -> {
            if (res.iva() == null || res.iva().isEmpty()) {
                return Mono.error((Throwable)new CustomException("No se encontr\u00f3 la lista de tipos de ivas", HttpStatus.NOT_FOUND));
            }
            return Mono.just((Object)res.iva());
        }).onErrorResume(ApiException.class, ex -> Mono.error((Throwable)ex));
    }

    @Generated
    public TipoIvaCacheService(ApiCodigoSriClient apiCodigoSriClient) {
        this.apiCodigoSriClient = apiCodigoSriClient;
    }
}

