/*
 * Decompiled with CFR 0.152.
 */
package com.facturacion.cache;

import com.facturacion.client.perseo.ApiFormasPagoClient;
import com.facturacion.data.Perseo.formasPago.empresa.FormasPagoEmpresa;
import com.facturacion.data.Perseo.formasPago.sri.FormasPagoSri;
import com.facturacion.exceptions.CustomException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FormasPagoCacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormasPagoCacheService.class);
    private final ApiFormasPagoClient apiFormasPagoClient;

    @Cacheable(value={"formasPagoEmpresa"})
    public Mono<List<FormasPagoEmpresa>> obtenerListaFormasPagoEmpresa() {
        log.warn("Consultando el api de formas de pago de la empresa");
        return this.apiFormasPagoClient.obtenerFormasPagoEmpresaApi().flatMap(response -> {
            if (response.formaPagoEmpresa() == null || response.formaPagoEmpresa().isEmpty()) {
                Mono.error((Throwable)new CustomException("No se encontr\u00f3 contenido en la lista de formas de pago", HttpStatus.NOT_FOUND));
            }
            return Mono.just((Object)response.formaPagoEmpresa());
        });
    }

    @Cacheable(value={"formasPagoSRI"})
    public Mono<List<FormasPagoSri>> obtenerListaFormasPagoSri() {
        log.warn("Consultando el api de formas de pago del sri");
        return this.apiFormasPagoClient.obtenerFormasPagoSriApi().flatMap(response -> {
            if (response.formaPagoSri() == null || response.formaPagoSri().isEmpty()) {
                Mono.error((Throwable)new CustomException("No se encontr\u00f3 contenido en la lista de formas de pago del SRI", HttpStatus.NOT_FOUND));
            }
            return Mono.just((Object)response.formaPagoSri());
        });
    }

    @Generated
    public FormasPagoCacheService(ApiFormasPagoClient apiFormasPagoClient) {
        this.apiFormasPagoClient = apiFormasPagoClient;
    }
}

