/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.infrastructure.config;

import com.payments.tws.infrastructure.adapter.output.persistence.entity.RequestLogEntity;
import com.payments.tws.infrastructure.adapter.output.persistence.repository.JpaRequestLogRepository;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class RequestLoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingFilter.class);
    private final JpaRequestLogRepository requestLogRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        long startTime = System.currentTimeMillis();
        try {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - startTime;
            try {
                String requestBody = new String(requestWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
                String responseBody = new String(responseWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
                responseWrapper.copyBodyToResponse();
                RequestLogEntity logEntity = RequestLogEntity.builder().method(request.getMethod()).uri(request.getRequestURI()).clientIp(this.getClientIp(request)).userAgent(request.getHeader("User-Agent")).requestBody(requestBody).responseBody(responseBody).responseStatus(response.getStatus()).executionTimeMs(Long.valueOf(duration)).build();
                this.requestLogRepository.save((Object)logEntity);
                log.info("Request audit saved: {} {} ({})", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus()});
            }
            catch (Exception e) {
                log.error("Error saving request log", (Throwable)e);
            }
            throw throwable;
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            String requestBody = new String(requestWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
            String responseBody = new String(responseWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
            responseWrapper.copyBodyToResponse();
            RequestLogEntity logEntity = RequestLogEntity.builder().method(request.getMethod()).uri(request.getRequestURI()).clientIp(this.getClientIp(request)).userAgent(request.getHeader("User-Agent")).requestBody(requestBody).responseBody(responseBody).responseStatus(response.getStatus()).executionTimeMs(Long.valueOf(duration)).build();
            this.requestLogRepository.save((Object)logEntity);
            log.info("Request audit saved: {} {} ({})", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus()});
        }
        catch (Exception e) {
            log.error("Error saving request log", (Throwable)e);
        }
    }

    private String getClientIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0];
        }
        return request.getRemoteAddr();
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/images") || path.contains("h2-console");
    }

    public RequestLoggingFilter(JpaRequestLogRepository requestLogRepository) {
        this.requestLogRepository = requestLogRepository;
    }
}

