/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.infrastructure.adapter.output.persistence.entity;

import com.payments.tws.infrastructure.adapter.output.persistence.entity.RequestLogEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name="request_logs")
public class RequestLogEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String method;
    private String uri;
    private String clientIp;
    private String userAgent;
    @Column(columnDefinition="TEXT")
    private String requestBody;
    @Column(columnDefinition="TEXT")
    private String responseBody;
    private int responseStatus;
    private Long executionTimeMs;
    private LocalDateTime timestamp;
    @Column(columnDefinition="TEXT")
    private String authTokenDetails;
    @Column(columnDefinition="TEXT")
    private String errorMessage;

    @PrePersist
    protected void onCreate() {
        this.timestamp = LocalDateTime.now();
    }

    public static RequestLogEntityBuilder builder() {
        return new RequestLogEntityBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public Long getExecutionTimeMs() {
        return this.executionTimeMs;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getAuthTokenDetails() {
        return this.authTokenDetails;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public void setExecutionTimeMs(Long executionTimeMs) {
        this.executionTimeMs = executionTimeMs;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setAuthTokenDetails(String authTokenDetails) {
        this.authTokenDetails = authTokenDetails;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestLogEntity)) {
            return false;
        }
        RequestLogEntity other = (RequestLogEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getResponseStatus() != other.getResponseStatus()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$executionTimeMs = this.getExecutionTimeMs();
        Long other$executionTimeMs = other.getExecutionTimeMs();
        if (this$executionTimeMs == null ? other$executionTimeMs != null : !((Object)this$executionTimeMs).equals(other$executionTimeMs)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$authTokenDetails = this.getAuthTokenDetails();
        String other$authTokenDetails = other.getAuthTokenDetails();
        if (this$authTokenDetails == null ? other$authTokenDetails != null : !this$authTokenDetails.equals(other$authTokenDetails)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestLogEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getResponseStatus();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $executionTimeMs = this.getExecutionTimeMs();
        result = result * 59 + ($executionTimeMs == null ? 43 : ((Object)$executionTimeMs).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $authTokenDetails = this.getAuthTokenDetails();
        result = result * 59 + ($authTokenDetails == null ? 43 : $authTokenDetails.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "RequestLogEntity(id=" + this.getId() + ", method=" + this.getMethod() + ", uri=" + this.getUri() + ", clientIp=" + this.getClientIp() + ", userAgent=" + this.getUserAgent() + ", requestBody=" + this.getRequestBody() + ", responseBody=" + this.getResponseBody() + ", responseStatus=" + this.getResponseStatus() + ", executionTimeMs=" + this.getExecutionTimeMs() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", authTokenDetails=" + this.getAuthTokenDetails() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public RequestLogEntity() {
    }

    public RequestLogEntity(Long id, String method, String uri, String clientIp, String userAgent, String requestBody, String responseBody, int responseStatus, Long executionTimeMs, LocalDateTime timestamp, String authTokenDetails, String errorMessage) {
        this.id = id;
        this.method = method;
        this.uri = uri;
        this.clientIp = clientIp;
        this.userAgent = userAgent;
        this.requestBody = requestBody;
        this.responseBody = responseBody;
        this.responseStatus = responseStatus;
        this.executionTimeMs = executionTimeMs;
        this.timestamp = timestamp;
        this.authTokenDetails = authTokenDetails;
        this.errorMessage = errorMessage;
    }
}

