/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.infrastructure.adapter.output.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.payments.tws.domain.model.Order;
import com.payments.tws.domain.model.PaymentReference;
import com.payments.tws.domain.model.User;
import com.payments.tws.domain.port.out.TransactionRepositoryPort;
import com.payments.tws.infrastructure.adapter.output.persistence.entity.TransactionEntity;
import com.payments.tws.infrastructure.adapter.output.persistence.repository.JpaTransactionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransactionPersistenceAdapter
implements TransactionRepositoryPort {
    private static final Logger log = LoggerFactory.getLogger(TransactionPersistenceAdapter.class);
    private final JpaTransactionRepository repository;
    private final ObjectMapper objectMapper;

    public void saveTransaction(User user, Order order, PaymentReference reference) {
        try {
            String rawDataJson = reference.getRawData() != null ? this.objectMapper.writeValueAsString(reference.getRawData()) : "{}";
            String tokenDetailsJson = null;
            if (reference.getAuditData() != null && reference.getAuditData().containsKey("tokenGeneration")) {
                tokenDetailsJson = this.objectMapper.writeValueAsString(reference.getAuditData().get("tokenGeneration"));
            }
            TransactionEntity entity = TransactionEntity.builder().userId(user.getId()).userEmail(user.getEmail()).amount(order.getAmount()).description(order.getDescription()).devReference(order.getDevReference()).paymentReference(reference.getReference()).status(reference.isSuccess() ? "INIT_SUCCESS" : "INIT_FAILURE").rawData(rawDataJson).tokenDetails(tokenDetailsJson).build();
            this.repository.save((Object)entity);
            log.info("Transacci\u00f3n guardada en DB: {}", (Object)entity.getId());
        }
        catch (Exception e) {
            log.error("Error al guardar transacci\u00f3n en base de datos", (Throwable)e);
        }
    }

    public TransactionPersistenceAdapter(JpaTransactionRepository repository, ObjectMapper objectMapper) {
        this.repository = repository;
        this.objectMapper = objectMapper;
    }
}

