/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.infrastructure.adapter.output.paymentez;

import com.payments.tws.infrastructure.adapter.output.persistence.entity.AuthTokenEntity;
import com.payments.tws.infrastructure.adapter.output.persistence.repository.JpaAuthTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TokenStorageService {
    private static final Logger log = LoggerFactory.getLogger(TokenStorageService.class);
    private final JpaAuthTokenRepository authTokenRepository;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveToken(String token, String appCode, long timestamp, String uniqTokenString, String uniqTokenHash, String generationLogic) {
        try {
            AuthTokenEntity entity = AuthTokenEntity.builder().token(token).appCode(appCode).timestamp(Long.valueOf(timestamp)).uniqTokenString(uniqTokenString).uniqTokenHash(uniqTokenHash).generationLogic(generationLogic).build();
            this.authTokenRepository.save((Object)entity);
            log.info("Token persisted successfully in separate transaction. ID: {}", (Object)entity.getId());
        }
        catch (Exception e) {
            log.error("Failed to persist token isolate", (Throwable)e);
        }
    }

    public TokenStorageService(JpaAuthTokenRepository authTokenRepository) {
        this.authTokenRepository = authTokenRepository;
    }
}

