/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.infrastructure.adapter.output.paymentez;

import com.payments.tws.infrastructure.adapter.output.paymentez.TokenDetails;
import com.payments.tws.infrastructure.adapter.output.paymentez.TokenStorageService;
import com.payments.tws.infrastructure.config.PaymentezConfig;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentezAuthService {
    private static final Logger log = LoggerFactory.getLogger(PaymentezAuthService.class);
    private final PaymentezConfig config;
    private final TokenStorageService tokenStorageService;

    public TokenDetails generateAuthToken() {
        try {
            long unixTimestamp = System.currentTimeMillis() / 1000L;
            String uniqTokenString = this.config.getAppKey() + unixTimestamp;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(uniqTokenString.getBytes(StandardCharsets.UTF_8));
            String uniqTokenHash = this.bytesToHex(hashBytes);
            String tokenString = this.config.getAppCode() + ";" + unixTimestamp + ";" + uniqTokenHash;
            String authToken = Base64.getEncoder().encodeToString(tokenString.getBytes(StandardCharsets.UTF_8));
            String logLogic = String.format("appCode=%s; timestamp=%d; sha256(appKey+%d)=%s", this.config.getAppCode(), unixTimestamp, unixTimestamp, uniqTokenHash);
            this.tokenStorageService.saveToken(authToken, this.config.getAppCode(), unixTimestamp, uniqTokenString, uniqTokenHash, logLogic);
            return TokenDetails.builder().token(authToken).timestamp(unixTimestamp).uniqTokenHash(uniqTokenHash).generationLogic(logLogic).build();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error al generar Auth-Token", (Throwable)e);
            throw new RuntimeException("Error al generar Auth-Token", e);
        }
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public PaymentezAuthService(PaymentezConfig config, TokenStorageService tokenStorageService) {
        this.config = config;
        this.tokenStorageService = tokenStorageService;
    }
}

