/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.infrastructure.adapter.output.paymentez;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.payments.tws.domain.model.Card;
import com.payments.tws.domain.model.Order;
import com.payments.tws.domain.model.PaymentReference;
import com.payments.tws.domain.model.User;
import com.payments.tws.domain.port.out.PaymentGatewayPort;
import com.payments.tws.infrastructure.adapter.output.paymentez.PaymentezAuthService;
import com.payments.tws.infrastructure.adapter.output.paymentez.TokenDetails;
import com.payments.tws.infrastructure.config.PaymentezConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class PaymentezAdapter
implements PaymentGatewayPort {
    private static final Logger log = LoggerFactory.getLogger(PaymentezAdapter.class);
    private final PaymentezConfig config;
    private final PaymentezAuthService authService;
    private final WebClient.Builder webClientBuilder;
    private final ObjectMapper objectMapper;

    public PaymentReference initReference(User user, Order order) {
        try {
            TokenDetails tokenInfo = this.authService.generateAuthToken();
            Map payload = this.buildPayload(user, order);
            String response = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(this.config.getApiUrl() + "/v2/transaction/init_reference/", new Object[0])).header("Content-Type", new String[]{"application/json"})).header("Auth-Token", new String[]{tokenInfo.getToken()})).bodyValue((Object)payload).retrieve().bodyToMono(String.class).block();
            JsonNode jsonResponse = this.objectMapper.readTree(response);
            String reference = this.extractReference(jsonResponse);
            HashMap<String, TokenDetails> auditData = new HashMap<String, TokenDetails>();
            auditData.put("tokenGeneration", tokenInfo);
            if (reference != null) {
                return PaymentReference.builder().success(true).reference(reference).rawData((Object)jsonResponse).auditData(auditData).build();
            }
            return PaymentReference.builder().success(false).error("No reference found").auditData(auditData).build();
        }
        catch (Exception e) {
            log.error("Error initReference", (Throwable)e);
            return PaymentReference.builder().success(false).error(e.getMessage()).build();
        }
    }

    public Map<String, Object> refund(String transactionId, String amount) {
        return this.callApi("/v2/transaction/refund/", Map.of("transaction", Map.of("id", transactionId), "order", Map.of("amount", amount)));
    }

    public List<Card> listCards(String userId) {
        try {
            TokenDetails tokenInfo = this.authService.generateAuthToken();
            String response = (String)this.webClientBuilder.build().get().uri(this.config.getApiUrl() + "/v2/card/list?uid=" + userId, new Object[0]).header("Auth-Token", new String[]{tokenInfo.getToken()}).retrieve().bodyToMono(String.class).block();
            JsonNode root = this.objectMapper.readTree(response);
            ArrayList<Card> cards = new ArrayList<Card>();
            if (root.has("cards")) {
                for (JsonNode node : root.get("cards")) {
                    cards.add(Card.builder().token(node.get("token").asText()).status(node.get("status").asText()).bin(node.get("bin").asText()).lastFour(node.get("last_four").asText()).brand(node.get("brand").asText()).holderName(node.has("holder_name") ? node.get("holder_name").asText() : "").expiryMonth(node.has("expiry_month") ? Integer.valueOf(node.get("expiry_month").asInt()) : null).expiryYear(node.has("expiry_year") ? Integer.valueOf(node.get("expiry_year").asInt()) : null).type(node.has("type") ? node.get("type").asText() : "").build());
                }
            }
            return cards;
        }
        catch (Exception e) {
            log.error("Error listing cards", (Throwable)e);
            return new ArrayList<Card>();
        }
    }

    public boolean deleteCard(String userId, String token) {
        Map result = this.callApi("/v2/card/delete/", Map.of("user", Map.of("id", userId), "card", Map.of("token", token)));
        return result != null && "card deleted".equals(result.get("message"));
    }

    public Map<String, Object> debitWithToken(User user, String cardToken, Order order) {
        HashMap<String, Map<String, String>> payload = new HashMap<String, Map<String, String>>();
        payload.put("user", Map.of("id", user.getId(), "email", user.getEmail()));
        payload.put("card", Map.of("token", cardToken));
        HashMap<String, String> orderMap = new HashMap<String, String>();
        orderMap.put("amount", order.getAmount());
        orderMap.put("description", order.getDescription());
        orderMap.put("dev_reference", order.getDevReference());
        orderMap.put("vat", order.getVat());
        payload.put("order", orderMap);
        return this.callApi("/v2/transaction/debit/", payload);
    }

    public Map<String, Object> verifyTransaction(String transactionId, String type) {
        return this.callApi("/v2/transaction/verify/", Map.of("transaction", Map.of("id", transactionId), "type", type));
    }

    private Map<String, Object> callApi(String endpoint, Map<String, Object> payload) {
        try {
            TokenDetails tokenInfo = this.authService.generateAuthToken();
            String response = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(this.config.getApiUrl() + endpoint, new Object[0])).header("Content-Type", new String[]{"application/json"})).header("Auth-Token", new String[]{tokenInfo.getToken()})).bodyValue(payload).retrieve().bodyToMono(String.class).block();
            return (Map)this.objectMapper.readValue(response, Map.class);
        }
        catch (Exception e) {
            log.error("Error calling API " + endpoint, (Throwable)e);
            HashMap<String, Object> err = new HashMap<String, Object>();
            err.put("success", false);
            err.put("error", e.getMessage());
            return err;
        }
    }

    private Map<String, Object> buildPayload(User user, Order order) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("user", Map.of("id", user.getId(), "email", user.getEmail()));
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        orderMap.put("amount", order.getAmount());
        orderMap.put("description", order.getDescription());
        orderMap.put("dev_reference", order.getDevReference());
        orderMap.put("vat", order.getVat());
        orderMap.put("taxable_amount", order.getTaxableAmount());
        orderMap.put("tax_percentage", order.getTaxPercentage());
        if (order.getInstallmentsType() != null) {
            orderMap.put("installments_type", order.getInstallmentsType());
        }
        payload.put("order", orderMap);
        return payload;
    }

    private String extractReference(JsonNode response) {
        JsonNode checkout;
        if (response.has("checkout") && response.get("checkout").has("reference")) {
            return response.get("checkout").get("reference").asText();
        }
        if (response.has("reference")) {
            return response.get("reference").asText();
        }
        if (response.has("data") && response.get("data").has("checkout") && (checkout = response.get("data").get("checkout")).has("reference")) {
            return checkout.get("reference").asText();
        }
        return null;
    }

    public PaymentezAdapter(PaymentezConfig config, PaymentezAuthService authService, WebClient.Builder webClientBuilder, ObjectMapper objectMapper) {
        this.config = config;
        this.authService = authService;
        this.webClientBuilder = webClientBuilder;
        this.objectMapper = objectMapper;
    }
}

