/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.payments.tws.infrastructure.adapter.input.rest.dto.WebhookPayload;
import com.payments.tws.infrastructure.adapter.output.persistence.entity.WebhookLogEntity;
import com.payments.tws.infrastructure.adapter.output.persistence.repository.JpaTransactionRepository;
import com.payments.tws.infrastructure.adapter.output.persistence.repository.JpaWebhookLogRepository;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/webhook"})
public class WebhookController {
    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    private final JpaWebhookLogRepository webhookLogRepository;
    private final JpaTransactionRepository transactionRepository;
    private final ObjectMapper objectMapper;

    @PostMapping(value={"/payhook"})
    public ResponseEntity<String> handleWebhook(@RequestBody Map<String, Object> rawPayloadMap) {
        try {
            String rawJson = this.objectMapper.writeValueAsString(rawPayloadMap);
            log.info("Webhook RAW recibido de Paymentez: {}", (Object)rawJson);
            WebhookPayload payload = (WebhookPayload)this.objectMapper.convertValue(rawPayloadMap, WebhookPayload.class);
            WebhookLogEntity logEntity = WebhookLogEntity.builder().transactionId(payload.getTransaction() != null ? payload.getTransaction().getId() : "UNKNOWN").status(payload.getTransaction() != null ? payload.getTransaction().getStatus() : "UNKNOWN").rawPayload(rawJson).version("v1").build();
            this.webhookLogRepository.save((Object)logEntity);
            log.info("Webhook guardado en DB con ID: {}", (Object)logEntity.getId());
            if (payload.getTransaction() != null && payload.getTransaction().getDevReference() != null) {
                String devReference = payload.getTransaction().getDevReference();
                this.transactionRepository.findByDevReference(devReference).ifPresent(transaction -> {
                    transaction.setStatus(payload.getTransaction().getStatus());
                    transaction.setAuthorizationCode(payload.getTransaction().getAuthorizationCode());
                    transaction.setCheckoutResponse(rawJson);
                    this.transactionRepository.save(transaction);
                    log.info("Transacci\u00f3n {} actualizada con datos del webhook.", (Object)devReference);
                });
            }
            if (payload.getTransaction() != null) {
                String status = payload.getTransaction().getStatus();
                String id = payload.getTransaction().getId();
                log.info("Transacci\u00f3n {} estado: {}", (Object)id, (Object)status);
            }
        }
        catch (Exception e) {
            log.error("Error procesando webhook", (Throwable)e);
        }
        return ResponseEntity.ok((Object)"Webhook received");
    }

    public WebhookController(JpaWebhookLogRepository webhookLogRepository, JpaTransactionRepository transactionRepository, ObjectMapper objectMapper) {
        this.webhookLogRepository = webhookLogRepository;
        this.transactionRepository = transactionRepository;
        this.objectMapper = objectMapper;
    }
}

