/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.controller;

import com.payments.tws.domain.model.Order;
import com.payments.tws.domain.model.PaymentReference;
import com.payments.tws.domain.model.User;
import com.payments.tws.domain.port.in.PaymentUseCase;
import com.payments.tws.infrastructure.adapter.input.rest.dto.InitReferenceRequest;
import com.payments.tws.infrastructure.adapter.input.rest.dto.InitReferenceResponse;
import jakarta.validation.Valid;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pay"})
public class PaymentController {
    private static final Logger log = LoggerFactory.getLogger(PaymentController.class);
    private final PaymentUseCase paymentUseCase;

    @PostMapping(value={"/init-order"})
    public ResponseEntity<InitReferenceResponse> initReference(@Valid @RequestBody InitReferenceRequest request) {
        log.info("Recibida solicitud de inicializaci\u00f3n de pago: {}", (Object)request);
        User user = User.builder().id(request.getUser().getId()).email(request.getUser().getEmail()).build();
        Order order = Order.builder().amount(request.getOrder().getAmount()).description(request.getOrder().getDescription()).devReference(request.getOrder().getDevReference()).vat(request.getOrder().getVat()).taxableAmount(request.getOrder().getTaxableAmount()).taxPercentage(request.getOrder().getTaxPercentage()).installmentsType(request.getOrder().getInstallmentsType()).build();
        PaymentReference result = this.paymentUseCase.initReference(user, order);
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)InitReferenceResponse.success((String)result.getReference(), (Object)result.getRawData()));
        }
        return ResponseEntity.badRequest().body((Object)InitReferenceResponse.error((String)result.getError()));
    }

    @PostMapping(value={"/refund"})
    public ResponseEntity<Map<String, Object>> refund(@RequestBody Map<String, Object> payload) {
        Map transaction = (Map)payload.get("transaction");
        Map order = (Map)payload.get("order");
        String transactionId = (String)transaction.get("id");
        String amount = (String)order.get("amount");
        log.info("Recibida solicitud de reembolso para TX: {}", (Object)transactionId);
        Map response = this.paymentUseCase.refund(transactionId, amount);
        return ResponseEntity.ok((Object)response);
    }

    public PaymentController(PaymentUseCase paymentUseCase) {
        this.paymentUseCase = paymentUseCase;
    }
}

