/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.controller;

import com.payments.tws.domain.model.Order;
import com.payments.tws.domain.model.User;
import com.payments.tws.domain.port.in.CardUseCase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cards"})
public class CardController {
    private static final Logger log = LoggerFactory.getLogger(CardController.class);
    private final CardUseCase cardUseCase;

    @GetMapping(value={"/{userId}"})
    public ResponseEntity<Map<String, Object>> listCards(@PathVariable String userId) {
        log.info("Listando tarjetas para usuario: {}", (Object)userId);
        return ResponseEntity.ok(Map.of("cards", this.cardUseCase.listCards(userId)));
    }

    @DeleteMapping(value={"/{userId}/{token}"})
    public ResponseEntity<Map<String, Object>> deleteCard(@PathVariable String userId, @PathVariable String token) {
        log.info("Eliminando tarjeta {} para usuario: {}", (Object)token, (Object)userId);
        boolean success = this.cardUseCase.deleteCard(userId, token);
        return ResponseEntity.ok(Map.of("message", success ? "card deleted" : "error deleting card", "success", success));
    }

    @PostMapping(value={"/debit"})
    public ResponseEntity<Map<String, Object>> debitWithToken(@RequestBody Map<String, Object> payload) {
        String userId = (String)payload.get("userId");
        String email = (String)payload.get("email");
        String cardToken = (String)payload.get("cardToken");
        Map orderMap = (Map)payload.get("order");
        User user = User.builder().id(userId).email(email).build();
        Order order = Order.builder().amount((String)orderMap.get("amount")).description((String)orderMap.get("description")).devReference((String)orderMap.get("devReference")).vat((String)orderMap.get("vat")).build();
        log.info("Procesando d\u00e9bito con token para usuario: {}", (Object)userId);
        Map response = this.cardUseCase.debitWithToken(user, cardToken, order);
        return ResponseEntity.ok((Object)response);
    }

    public CardController(CardUseCase cardUseCase) {
        this.cardUseCase = cardUseCase;
    }
}

