/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.application.service;

import com.payments.tws.domain.model.Order;
import com.payments.tws.domain.model.PaymentReference;
import com.payments.tws.domain.model.User;
import com.payments.tws.domain.port.in.PaymentUseCase;
import com.payments.tws.domain.port.out.PaymentGatewayPort;
import com.payments.tws.domain.port.out.TransactionRepositoryPort;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService
implements PaymentUseCase {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final PaymentGatewayPort paymentGatewayPort;
    private final TransactionRepositoryPort transactionRepository;

    public PaymentReference initReference(User user, Order order) {
        log.info("UseCase: Iniciando referencia de pago para usuario: {}", (Object)user.getId());
        PaymentReference response = this.paymentGatewayPort.initReference(user, order);
        this.transactionRepository.saveTransaction(user, order, response);
        return response;
    }

    public Map<String, Object> refund(String transactionId, String amount) {
        log.info("UseCase: Procesando reembolso para transacci\u00f3n: {}", (Object)transactionId);
        return this.paymentGatewayPort.refund(transactionId, amount);
    }

    public Map<String, Object> verifyTransaction(String transactionId, String type) {
        log.info("UseCase: Verificando transacci\u00f3n: {}", (Object)transactionId);
        return this.paymentGatewayPort.verifyTransaction(transactionId, type);
    }

    public PaymentService(PaymentGatewayPort paymentGatewayPort, TransactionRepositoryPort transactionRepository) {
        this.paymentGatewayPort = paymentGatewayPort;
        this.transactionRepository = transactionRepository;
    }
}

