/*
 * Decompiled with CFR 0.152.
 */
package com.payments.tws.application.service;

import com.payments.tws.domain.model.Card;
import com.payments.tws.domain.model.Order;
import com.payments.tws.domain.model.User;
import com.payments.tws.domain.port.in.CardUseCase;
import com.payments.tws.domain.port.out.PaymentGatewayPort;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardService
implements CardUseCase {
    private static final Logger log = LoggerFactory.getLogger(CardService.class);
    private final PaymentGatewayPort paymentGatewayPort;

    public List<Card> listCards(String userId) {
        log.info("UseCase: Listando tarjetas para usuario: {}", (Object)userId);
        return this.paymentGatewayPort.listCards(userId);
    }

    public boolean deleteCard(String userId, String token) {
        log.info("UseCase: Eliminando tarjeta {} para usuario: {}", (Object)token, (Object)userId);
        return this.paymentGatewayPort.deleteCard(userId, token);
    }

    public Map<String, Object> debitWithToken(User user, String cardToken, Order order) {
        log.info("UseCase: Procesando d\u00e9bito con token para usuario: {}", (Object)user.getId());
        return this.paymentGatewayPort.debitWithToken(user, cardToken, order);
    }

    public CardService(PaymentGatewayPort paymentGatewayPort) {
        this.paymentGatewayPort = paymentGatewayPort;
    }
}

